/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.AbstractBoxParser;
import com.frostwire.mp4.Hex;
import com.frostwire.mp4.boxes.Box;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyBoxParserImpl
extends AbstractBoxParser {
    Properties mapping;
    Pattern p = Pattern.compile("(.*)\\((.*?)\\)");

    public PropertyBoxParserImpl(String ... stringArray) {
        this.mapping = new Properties();
        this.put(this.mapping, "meta-ilst", "apple.AppleItemListBox()");
        this.put(this.mapping, "-----name", "apple.AppleNameBox()");
        this.put(this.mapping, "-----mean", "apple.AppleMeanBox()");
        this.put(this.mapping, "-----data", "apple.AppleDataBox()");
        this.put(this.mapping, "ilst-covr", "apple.AppleCoverBox()");
        this.put(this.mapping, "ilst-name", "apple.AppleNameBox()");
        this.put(this.mapping, "ilst-data", "apple.AppleDataBox()");
        this.put(this.mapping, "stsd-samr", "sampleentry.AudioSampleEntry(type)");
        this.put(this.mapping, "stsd-sawb", "sampleentry.AudioSampleEntry(type)");
        this.put(this.mapping, "stsd-mp4a", "sampleentry.AudioSampleEntry(type)");
        this.put(this.mapping, "stsd-drms", "sampleentry.AudioSampleEntry(type)");
        this.put(this.mapping, "stsd-alac", "sampleentry.AudioSampleEntry(type)");
        this.put(this.mapping, "stsd-owma", "sampleentry.AudioSampleEntry(type)");
        this.put(this.mapping, "stsd-ac-3", "sampleentry.AudioSampleEntry(type)");
        this.put(this.mapping, "stsd-ec-3", "sampleentry.AudioSampleEntry(type)");
        this.put(this.mapping, "stsd-lpcm", "sampleentry.AudioSampleEntry(type)");
        this.put(this.mapping, "stsd-dtsc", "sampleentry.AudioSampleEntry(type)");
        this.put(this.mapping, "stsd-dtsh", "sampleentry.AudioSampleEntry(type)");
        this.put(this.mapping, "stsd-dtsl", "sampleentry.AudioSampleEntry(type)");
        this.put(this.mapping, "stsd-dtse", "sampleentry.AudioSampleEntry(type)");
        this.put(this.mapping, "stsd-mlpa", "sampleentry.AudioSampleEntry(type)");
        this.put(this.mapping, "stsd-enca", "sampleentry.AudioSampleEntry(type)");
        this.put(this.mapping, "ftyp", "FileTypeBox()");
        this.put(this.mapping, "mdat", "mdat.MediaDataBox()");
        this.put(this.mapping, "moov", "MovieBox()");
        this.put(this.mapping, "mvhd", "MovieHeaderBox()");
        this.put(this.mapping, "trak", "TrackBox()");
        this.put(this.mapping, "tkhd", "TrackHeaderBox()");
        this.put(this.mapping, "edts", "EditBox()");
        this.put(this.mapping, "elst", "EditListBox()");
        this.put(this.mapping, "mdia", "MediaBox()");
        this.put(this.mapping, "mdhd", "MediaHeaderBox()");
        this.put(this.mapping, "hdlr", "HandlerBox()");
        this.put(this.mapping, "minf", "MediaInformationBox()");
        this.put(this.mapping, "vmhd", "VideoMediaHeaderBox()");
        this.put(this.mapping, "smhd", "SoundMediaHeaderBox()");
        this.put(this.mapping, "sthd", "SubtitleMediaHeaderBox()");
        this.put(this.mapping, "hmhd", "HintMediaHeaderBox()");
        this.put(this.mapping, "dinf", "DataInformationBox()");
        this.put(this.mapping, "dref", "DataReferenceBox()");
        this.put(this.mapping, "url ", "DataEntryUrlBox()");
        this.put(this.mapping, "stbl", "SampleTableBox()");
        this.put(this.mapping, "ctts", "CompositionTimeToSample()");
        this.put(this.mapping, "stsd", "SampleDescriptionBox()");
        this.put(this.mapping, "stts", "TimeToSampleBox()");
        this.put(this.mapping, "stsc", "SampleToChunkBox()");
        this.put(this.mapping, "stsz", "SampleSizeBox()");
        this.put(this.mapping, "stco", "StaticChunkOffsetBox()");
        this.put(this.mapping, "udta", "UserDataBox()");
        this.put(this.mapping, "meta", "MetaBox()");
        this.put(this.mapping, "uuid", "UserBox(userType)");
        this.put(this.mapping, "mvex", "fragment.MovieExtendsBox()");
        this.put(this.mapping, "trex", "fragment.TrackExtendsBox()");
        this.put(this.mapping, "moof", "fragment.MovieFragmentBox()");
        this.put(this.mapping, "traf", "fragment.TrackFragmentBox()");
        this.put(this.mapping, "tfhd", "fragment.TrackFragmentHeaderBox()");
        this.put(this.mapping, "trun", "fragment.TrackRunBox()");
        this.put(this.mapping, "sdtp", "SampleDependencyTypeBox()");
        this.put(this.mapping, "esds", "mp4.ESDescriptorBox()");
        this.put(this.mapping, "default", "UnknownBox(type)");
    }

    public PropertyBoxParserImpl(Properties properties) {
        this.mapping = properties;
    }

    private void put(Properties properties, String string, String string2) {
        properties.put(string, "com.frostwire.mp4.boxes." + string2);
    }

    @Override
    public Class<? extends Box> getClassForFourCc(String string, byte[] byArray, String string2) {
        FourCcToBox fourCcToBox = new FourCcToBox(string, byArray, string2).invoke();
        try {
            return Class.forName(fourCcToBox.clazzName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    @Override
    public Box createBox(String string, byte[] byArray, String string2) {
        FourCcToBox fourCcToBox = new FourCcToBox(string, byArray, string2).invoke();
        String[] stringArray = fourCcToBox.getParam();
        String string3 = fourCcToBox.getClazzName();
        try {
            if (stringArray[0].trim().length() == 0) {
                stringArray = new String[]{};
            }
            Class<?> clazz = Class.forName(string3);
            Class[] classArray = new Class[stringArray.length];
            Object[] objectArray = new Object[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                if ("userType".equals(stringArray[i])) {
                    objectArray[i] = byArray;
                    classArray[i] = byte[].class;
                    continue;
                }
                if ("type".equals(stringArray[i])) {
                    objectArray[i] = string;
                    classArray[i] = String.class;
                    continue;
                }
                if ("parent".equals(stringArray[i])) {
                    objectArray[i] = string2;
                    classArray[i] = String.class;
                    continue;
                }
                throw new InternalError("No such param: " + stringArray[i]);
            }
            try {
                Constructor<?> constructor = stringArray.length > 0 ? clazz.getConstructor(classArray) : clazz.getConstructor(new Class[0]);
                return (Box)constructor.newInstance(objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    private class FourCcToBox {
        private String type;
        private byte[] userType;
        private String parent;
        private String clazzName;
        private String[] param;

        public FourCcToBox(String string, byte[] byArray, String string2) {
            this.type = string;
            this.parent = string2;
            this.userType = byArray;
        }

        public String getClazzName() {
            return this.clazzName;
        }

        public String[] getParam() {
            return this.param;
        }

        public FourCcToBox invoke() {
            String string;
            if (this.userType != null) {
                if (!"uuid".equals(this.type)) {
                    throw new RuntimeException("we have a userType but no uuid box type. Something's wrong");
                }
                string = PropertyBoxParserImpl.this.mapping.getProperty(this.parent + "-uuid[" + Hex.encodeHex(this.userType).toUpperCase() + "]");
                if (string == null) {
                    string = PropertyBoxParserImpl.this.mapping.getProperty("uuid[" + Hex.encodeHex(this.userType).toUpperCase() + "]");
                }
                if (string == null) {
                    string = PropertyBoxParserImpl.this.mapping.getProperty("uuid");
                }
            } else {
                string = PropertyBoxParserImpl.this.mapping.getProperty(this.parent + "-" + this.type);
                if (string == null) {
                    string = PropertyBoxParserImpl.this.mapping.getProperty(this.type);
                }
            }
            if (string == null) {
                string = PropertyBoxParserImpl.this.mapping.getProperty("default");
            }
            if (string == null) {
                throw new RuntimeException("No box object found for " + this.type);
            }
            Matcher matcher = PropertyBoxParserImpl.this.p.matcher(string);
            boolean bl = matcher.matches();
            if (!bl) {
                throw new RuntimeException("Cannot work with that constructor: " + string);
            }
            this.clazzName = matcher.group(1);
            this.param = matcher.group(2).split(",");
            return this;
        }
    }
}

