/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4.boxes;

import com.frostwire.mp4.AbstractFullBox;
import com.frostwire.mp4.CastUtils;
import com.frostwire.mp4.IsoTypeReader;
import com.frostwire.mp4.IsoTypeWriter;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class EditListBox
extends AbstractFullBox {
    private List<Entry> entries = new LinkedList<Entry>();
    public static final String TYPE = "elst";

    public EditListBox() {
        super(TYPE);
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> list) {
        this.entries = list;
    }

    @Override
    protected long getContentSize() {
        long l = 8L;
        l = this.getVersion() == 1 ? (l += (long)(this.entries.size() * 20)) : (l += (long)(this.entries.size() * 12));
        return l;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        int n = CastUtils.l2i(IsoTypeReader.readUInt32(byteBuffer));
        this.entries = new LinkedList<Entry>();
        for (int i = 0; i < n; ++i) {
            this.entries.add(new Entry(this, byteBuffer));
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt32(byteBuffer, this.entries.size());
        for (Entry entry : this.entries) {
            entry.getContent(byteBuffer);
        }
    }

    public String toString() {
        return "EditListBox{entries=" + this.entries + '}';
    }

    public static class Entry {
        private long segmentDuration;
        private long mediaTime;
        private double mediaRate;
        EditListBox editListBox;

        public Entry(EditListBox editListBox, long l, long l2, double d) {
            this.segmentDuration = l;
            this.mediaTime = l2;
            this.mediaRate = d;
            this.editListBox = editListBox;
        }

        public Entry(EditListBox editListBox, ByteBuffer byteBuffer) {
            if (editListBox.getVersion() == 1) {
                this.segmentDuration = IsoTypeReader.readUInt64(byteBuffer);
                this.mediaTime = IsoTypeReader.readUInt64(byteBuffer);
                this.mediaRate = IsoTypeReader.readFixedPoint1616(byteBuffer);
            } else {
                this.segmentDuration = IsoTypeReader.readUInt32(byteBuffer);
                this.mediaTime = IsoTypeReader.readUInt32(byteBuffer);
                this.mediaRate = IsoTypeReader.readFixedPoint1616(byteBuffer);
            }
            this.editListBox = editListBox;
        }

        public long getSegmentDuration() {
            return this.segmentDuration;
        }

        public void setSegmentDuration(long l) {
            this.segmentDuration = l;
        }

        public long getMediaTime() {
            return this.mediaTime;
        }

        public void setMediaTime(long l) {
            this.mediaTime = l;
        }

        public double getMediaRate() {
            return this.mediaRate;
        }

        public void setMediaRate(double d) {
            this.mediaRate = d;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Entry entry = (Entry)object;
            if (this.mediaTime != entry.mediaTime) {
                return false;
            }
            return this.segmentDuration == entry.segmentDuration;
        }

        public int hashCode() {
            int n = (int)(this.segmentDuration ^ this.segmentDuration >>> 32);
            n = 31 * n + (int)(this.mediaTime ^ this.mediaTime >>> 32);
            return n;
        }

        public void getContent(ByteBuffer byteBuffer) {
            if (this.editListBox.getVersion() == 1) {
                IsoTypeWriter.writeUInt64(byteBuffer, this.segmentDuration);
                IsoTypeWriter.writeUInt64(byteBuffer, this.mediaTime);
            } else {
                IsoTypeWriter.writeUInt32(byteBuffer, CastUtils.l2i(this.segmentDuration));
                byteBuffer.putInt(CastUtils.l2i(this.mediaTime));
            }
            IsoTypeWriter.writeFixedPont1616(byteBuffer, this.mediaRate);
        }

        public String toString() {
            return "Entry{segmentDuration=" + this.segmentDuration + ", mediaTime=" + this.mediaTime + ", mediaRate=" + this.mediaRate + '}';
        }
    }
}

