/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4.boxes;

import com.frostwire.mp4.AbstractFullBox;
import com.frostwire.mp4.IsoTypeReader;
import com.frostwire.mp4.IsoTypeWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class SampleDependencyTypeBox
extends AbstractFullBox {
    public static final String TYPE = "sdtp";
    private List<Entry> entries = new ArrayList<Entry>();

    public SampleDependencyTypeBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        return 4 + this.entries.size();
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        for (Entry entry : this.entries) {
            IsoTypeWriter.writeUInt8(byteBuffer, entry.value);
        }
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        while (byteBuffer.remaining() > 0) {
            this.entries.add(new Entry(IsoTypeReader.readUInt8(byteBuffer)));
        }
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> list) {
        this.entries = list;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SampleDependencyTypeBox");
        stringBuilder.append("{entries=").append(this.entries);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static class Entry {
        private int value;

        public Entry(int n) {
            this.value = n;
        }

        public int getReserved() {
            return this.value >> 6 & 3;
        }

        public void setReserved(int n) {
            this.value = (n & 3) << 6 | this.value & 0x3F;
        }

        public int getSampleDependsOn() {
            return this.value >> 4 & 3;
        }

        public void setSampleDependsOn(int n) {
            this.value = (n & 3) << 4 | this.value & 0xCF;
        }

        public int getSampleIsDependentOn() {
            return this.value >> 2 & 3;
        }

        public void setSampleIsDependentOn(int n) {
            this.value = (n & 3) << 2 | this.value & 0xF3;
        }

        public int getSampleHasRedundancy() {
            return this.value & 3;
        }

        public void setSampleHasRedundancy(int n) {
            this.value = n & 3 | this.value & 0xFC;
        }

        public String toString() {
            return "Entry{reserved=" + this.getReserved() + ", sampleDependsOn=" + this.getSampleDependsOn() + ", sampleIsDependentOn=" + this.getSampleIsDependentOn() + ", sampleHasRedundancy=" + this.getSampleHasRedundancy() + '}';
        }
    }
}

