/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4.boxes;

import com.frostwire.mp4.IsoTypeReader;
import com.frostwire.mp4.IsoTypeWriter;
import com.frostwire.mp4.boxes.AbstractMediaHeaderBox;
import java.nio.ByteBuffer;

public class SoundMediaHeaderBox
extends AbstractMediaHeaderBox {
    public static final String TYPE = "smhd";
    private float balance;

    public SoundMediaHeaderBox() {
        super(TYPE);
    }

    public float getBalance() {
        return this.balance;
    }

    @Override
    protected long getContentSize() {
        return 8L;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.balance = IsoTypeReader.readFixedPoint88(byteBuffer);
        IsoTypeReader.readUInt16(byteBuffer);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeFixedPont88(byteBuffer, this.balance);
        IsoTypeWriter.writeUInt16(byteBuffer, 0);
    }

    public String toString() {
        return "SoundMediaHeaderBox[balance=" + this.getBalance() + "]";
    }
}

