/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4.boxes;

import com.frostwire.mp4.AbstractFullBox;
import com.frostwire.mp4.CastUtils;
import com.frostwire.mp4.IsoTypeReader;
import com.frostwire.mp4.IsoTypeWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class SubSampleInformationBox
extends AbstractFullBox {
    public static final String TYPE = "subs";
    private long entryCount;
    private List<SampleEntry> entries = new ArrayList<SampleEntry>();

    public SubSampleInformationBox() {
        super(TYPE);
    }

    public List<SampleEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<SampleEntry> list) {
        this.entries = list;
        this.entryCount = list.size();
    }

    @Override
    protected long getContentSize() {
        long l = 8L + 6L * this.entryCount;
        int n = 0;
        for (SampleEntry sampleEntry : this.entries) {
            n += sampleEntry.getSubsampleCount() * ((this.getVersion() == 1 ? 4 : 2) + 1 + 1 + 4);
        }
        return l + (long)n;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.entryCount = IsoTypeReader.readUInt32(byteBuffer);
        int n = 0;
        while ((long)n < this.entryCount) {
            SampleEntry sampleEntry = new SampleEntry();
            sampleEntry.setSampleDelta(IsoTypeReader.readUInt32(byteBuffer));
            int n2 = IsoTypeReader.readUInt16(byteBuffer);
            for (int i = 0; i < n2; ++i) {
                SampleEntry.SubsampleEntry subsampleEntry = new SampleEntry.SubsampleEntry();
                subsampleEntry.setSubsampleSize(this.getVersion() == 1 ? IsoTypeReader.readUInt32(byteBuffer) : (long)IsoTypeReader.readUInt16(byteBuffer));
                subsampleEntry.setSubsamplePriority(IsoTypeReader.readUInt8(byteBuffer));
                subsampleEntry.setDiscardable(IsoTypeReader.readUInt8(byteBuffer));
                subsampleEntry.setReserved(IsoTypeReader.readUInt32(byteBuffer));
                sampleEntry.addSubsampleEntry(subsampleEntry);
            }
            this.entries.add(sampleEntry);
            ++n;
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt32(byteBuffer, this.entries.size());
        for (SampleEntry sampleEntry : this.entries) {
            IsoTypeWriter.writeUInt32(byteBuffer, sampleEntry.getSampleDelta());
            IsoTypeWriter.writeUInt16(byteBuffer, sampleEntry.getSubsampleCount());
            List<SampleEntry.SubsampleEntry> list = sampleEntry.getSubsampleEntries();
            for (SampleEntry.SubsampleEntry subsampleEntry : list) {
                if (this.getVersion() == 1) {
                    IsoTypeWriter.writeUInt32(byteBuffer, subsampleEntry.getSubsampleSize());
                } else {
                    IsoTypeWriter.writeUInt16(byteBuffer, CastUtils.l2i(subsampleEntry.getSubsampleSize()));
                }
                IsoTypeWriter.writeUInt8(byteBuffer, subsampleEntry.getSubsamplePriority());
                IsoTypeWriter.writeUInt8(byteBuffer, subsampleEntry.getDiscardable());
                IsoTypeWriter.writeUInt32(byteBuffer, subsampleEntry.getReserved());
            }
        }
    }

    public String toString() {
        return "SubSampleInformationBox{entryCount=" + this.entryCount + ", entries=" + this.entries + '}';
    }

    public static class SampleEntry {
        private long sampleDelta;
        private int subsampleCount;
        private List<SubsampleEntry> subsampleEntries = new ArrayList<SubsampleEntry>();

        public long getSampleDelta() {
            return this.sampleDelta;
        }

        public void setSampleDelta(long l) {
            this.sampleDelta = l;
        }

        public int getSubsampleCount() {
            return this.subsampleCount;
        }

        public void setSubsampleCount(int n) {
            this.subsampleCount = n;
        }

        public List<SubsampleEntry> getSubsampleEntries() {
            return this.subsampleEntries;
        }

        public void addSubsampleEntry(SubsampleEntry subsampleEntry) {
            this.subsampleEntries.add(subsampleEntry);
            ++this.subsampleCount;
        }

        public String toString() {
            return "SampleEntry{sampleDelta=" + this.sampleDelta + ", subsampleCount=" + this.subsampleCount + ", subsampleEntries=" + this.subsampleEntries + '}';
        }

        public static class SubsampleEntry {
            private long subsampleSize;
            private int subsamplePriority;
            private int discardable;
            private long reserved;

            public long getSubsampleSize() {
                return this.subsampleSize;
            }

            public void setSubsampleSize(long l) {
                this.subsampleSize = l;
            }

            public int getSubsamplePriority() {
                return this.subsamplePriority;
            }

            public void setSubsamplePriority(int n) {
                this.subsamplePriority = n;
            }

            public int getDiscardable() {
                return this.discardable;
            }

            public void setDiscardable(int n) {
                this.discardable = n;
            }

            public long getReserved() {
                return this.reserved;
            }

            public void setReserved(long l) {
                this.reserved = l;
            }

            public String toString() {
                return "SubsampleEntry{subsampleSize=" + this.subsampleSize + ", subsamplePriority=" + this.subsamplePriority + ", discardable=" + this.discardable + ", reserved=" + this.reserved + '}';
            }
        }
    }
}

