/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4.boxes;

import com.frostwire.mp4.AbstractFullBox;
import com.frostwire.mp4.IsoTypeReader;
import com.frostwire.mp4.IsoTypeWriter;
import java.nio.ByteBuffer;

public class TrackHeaderBox
extends AbstractFullBox {
    public static final String TYPE = "tkhd";
    private long creationTime;
    private long modificationTime;
    private long trackId;
    private long duration;
    private int layer;
    private int alternateGroup;
    private float volume;
    private long[] matrix = new long[]{65536L, 0L, 0L, 0L, 65536L, 0L, 0L, 0L, 0x40000000L};
    private double width;
    private double height;

    public TrackHeaderBox() {
        super(TYPE);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public long getTrackId() {
        return this.trackId;
    }

    public long getDuration() {
        return this.duration;
    }

    public int getLayer() {
        return this.layer;
    }

    public int getAlternateGroup() {
        return this.alternateGroup;
    }

    public float getVolume() {
        return this.volume;
    }

    public long[] getMatrix() {
        return this.matrix;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    @Override
    protected long getContentSize() {
        long l = 4L;
        l = this.getVersion() == 1 ? (l += 32L) : (l += 20L);
        return l += 60L;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        if (this.getVersion() == 1) {
            this.creationTime = IsoTypeReader.readUInt64(byteBuffer);
            this.modificationTime = IsoTypeReader.readUInt64(byteBuffer);
            this.trackId = IsoTypeReader.readUInt32(byteBuffer);
            IsoTypeReader.readUInt32(byteBuffer);
            this.duration = IsoTypeReader.readUInt64(byteBuffer);
        } else {
            this.creationTime = IsoTypeReader.readUInt32(byteBuffer);
            this.modificationTime = IsoTypeReader.readUInt32(byteBuffer);
            this.trackId = IsoTypeReader.readUInt32(byteBuffer);
            IsoTypeReader.readUInt32(byteBuffer);
            this.duration = IsoTypeReader.readUInt32(byteBuffer);
        }
        IsoTypeReader.readUInt32(byteBuffer);
        IsoTypeReader.readUInt32(byteBuffer);
        this.layer = IsoTypeReader.readUInt16(byteBuffer);
        this.alternateGroup = IsoTypeReader.readUInt16(byteBuffer);
        this.volume = IsoTypeReader.readFixedPoint88(byteBuffer);
        IsoTypeReader.readUInt16(byteBuffer);
        this.matrix = new long[9];
        for (int i = 0; i < 9; ++i) {
            this.matrix[i] = IsoTypeReader.readUInt32(byteBuffer);
        }
        this.width = IsoTypeReader.readFixedPoint1616(byteBuffer);
        this.height = IsoTypeReader.readFixedPoint1616(byteBuffer);
    }

    @Override
    public void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        if (this.getVersion() == 1) {
            IsoTypeWriter.writeUInt64(byteBuffer, this.creationTime);
            IsoTypeWriter.writeUInt64(byteBuffer, this.modificationTime);
            IsoTypeWriter.writeUInt32(byteBuffer, this.trackId);
            IsoTypeWriter.writeUInt32(byteBuffer, 0L);
            IsoTypeWriter.writeUInt64(byteBuffer, this.duration);
        } else {
            IsoTypeWriter.writeUInt32(byteBuffer, this.creationTime);
            IsoTypeWriter.writeUInt32(byteBuffer, this.modificationTime);
            IsoTypeWriter.writeUInt32(byteBuffer, this.trackId);
            IsoTypeWriter.writeUInt32(byteBuffer, 0L);
            IsoTypeWriter.writeUInt32(byteBuffer, this.duration);
        }
        IsoTypeWriter.writeUInt32(byteBuffer, 0L);
        IsoTypeWriter.writeUInt32(byteBuffer, 0L);
        IsoTypeWriter.writeUInt16(byteBuffer, this.layer);
        IsoTypeWriter.writeUInt16(byteBuffer, this.alternateGroup);
        IsoTypeWriter.writeFixedPont88(byteBuffer, this.volume);
        IsoTypeWriter.writeUInt16(byteBuffer, 0);
        for (int i = 0; i < 9; ++i) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.matrix[i]);
        }
        IsoTypeWriter.writeFixedPont1616(byteBuffer, this.width);
        IsoTypeWriter.writeFixedPont1616(byteBuffer, this.height);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TrackHeaderBox[");
        stringBuilder.append("creationTime=").append(this.getCreationTime());
        stringBuilder.append(";");
        stringBuilder.append("modificationTime=").append(this.getModificationTime());
        stringBuilder.append(";");
        stringBuilder.append("trackId=").append(this.getTrackId());
        stringBuilder.append(";");
        stringBuilder.append("duration=").append(this.getDuration());
        stringBuilder.append(";");
        stringBuilder.append("layer=").append(this.getLayer());
        stringBuilder.append(";");
        stringBuilder.append("alternateGroup=").append(this.getAlternateGroup());
        stringBuilder.append(";");
        stringBuilder.append("volume=").append(this.getVolume());
        for (int i = 0; i < this.matrix.length; ++i) {
            stringBuilder.append(";");
            stringBuilder.append("matrix").append(i).append("=").append(this.matrix[i]);
        }
        stringBuilder.append(";");
        stringBuilder.append("width=").append(this.getWidth());
        stringBuilder.append(";");
        stringBuilder.append("height=").append(this.getHeight());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public void setCreationTime(long l) {
        this.creationTime = l;
    }

    public void setModificationTime(long l) {
        this.modificationTime = l;
    }

    public void setTrackId(long l) {
        this.trackId = l;
    }

    public void setDuration(long l) {
        this.duration = l;
    }

    public void setLayer(int n) {
        this.layer = n;
    }

    public void setAlternateGroup(int n) {
        this.alternateGroup = n;
    }

    public void setVolume(float f) {
        this.volume = f;
    }

    public void setMatrix(long[] lArray) {
        this.matrix = lArray;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public boolean isEnabled() {
        return (this.getFlags() & 1) > 0;
    }

    public boolean isInMovie() {
        return (this.getFlags() & 2) > 0;
    }

    public boolean isInPreview() {
        return (this.getFlags() & 4) > 0;
    }

    public boolean isInPoster() {
        return (this.getFlags() & 8) > 0;
    }
}

