/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4.boxes.apple;

import com.frostwire.mp4.AbstractBox;
import com.frostwire.mp4.ByteBufferByteChannel;
import com.frostwire.mp4.IsoTypeReader;
import com.frostwire.mp4.IsoTypeWriter;
import com.frostwire.mp4.Utf8;
import com.frostwire.mp4.boxes.Box;
import com.frostwire.mp4.boxes.ContainerBox;
import com.frostwire.mp4.boxes.apple.AppleDataBox;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public abstract class AbstractAppleMetaDataBox
extends AbstractBox
implements ContainerBox {
    private static Logger LOG = Logger.getLogger(AbstractAppleMetaDataBox.class.getName());
    AppleDataBox appleDataBox = new AppleDataBox();

    @Override
    public List<Box> getBoxes() {
        return Collections.singletonList(this.appleDataBox);
    }

    @Override
    public void setBoxes(List<Box> list) {
        if (list.size() != 1 || !(list.get(0) instanceof AppleDataBox)) {
            throw new IllegalArgumentException("This box only accepts one AppleDataBox child");
        }
        this.appleDataBox = (AppleDataBox)list.get(0);
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz) {
        return this.getBoxes(clazz, false);
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz, boolean bl) {
        if (clazz.isAssignableFrom(this.appleDataBox.getClass())) {
            return Collections.singletonList(this.appleDataBox);
        }
        return null;
    }

    public AbstractAppleMetaDataBox(String string) {
        super(string);
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        long l = IsoTypeReader.readUInt32(byteBuffer);
        String string = IsoTypeReader.read4cc(byteBuffer);
        assert ("data".equals(string));
        this.appleDataBox = new AppleDataBox();
        try {
            this.appleDataBox.parse(new ByteBufferByteChannel(byteBuffer), null, byteBuffer.remaining(), null);
            this.appleDataBox.parseDetails();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.appleDataBox.setParent(this);
    }

    @Override
    protected long getContentSize() {
        return this.appleDataBox.getSize();
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        try {
            this.appleDataBox.getBox(new ByteBufferByteChannel(byteBuffer));
        }
        catch (IOException iOException) {
            throw new RuntimeException("The Channel is based on a ByteBuffer and therefore it shouldn't throw any exception");
        }
    }

    @Override
    public long getNumOfBytesToFirstChild() {
        return this.getSize() - this.appleDataBox.getSize();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "appleDataBox=" + this.getValue() + '}';
    }

    static long toLong(byte by) {
        return by < 0 ? (long)(by + 256) : (long)by;
    }

    public void setValue(String string) {
        if (this.appleDataBox.getFlags() == 1) {
            this.appleDataBox = new AppleDataBox();
            this.appleDataBox.setVersion(0);
            this.appleDataBox.setFlags(1);
            this.appleDataBox.setFourBytes(new byte[4]);
            this.appleDataBox.setData(Utf8.convert(string));
        } else if (this.appleDataBox.getFlags() == 21) {
            byte[] byArray = this.appleDataBox.getData();
            this.appleDataBox = new AppleDataBox();
            this.appleDataBox.setVersion(0);
            this.appleDataBox.setFlags(21);
            this.appleDataBox.setFourBytes(new byte[4]);
            ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
            if (byArray.length == 1) {
                IsoTypeWriter.writeUInt8(byteBuffer, Byte.parseByte(string) & 0xFF);
            } else if (byArray.length == 2) {
                IsoTypeWriter.writeUInt16(byteBuffer, Integer.parseInt(string));
            } else if (byArray.length == 4) {
                IsoTypeWriter.writeUInt32(byteBuffer, Long.parseLong(string));
            } else if (byArray.length == 8) {
                IsoTypeWriter.writeUInt64(byteBuffer, Long.parseLong(string));
            } else {
                throw new Error("The content length within the appleDataBox is neither 1, 2, 4 or 8. I can't handle that!");
            }
            this.appleDataBox.setData(byteBuffer.array());
        } else if (this.appleDataBox.getFlags() == 0) {
            this.appleDataBox = new AppleDataBox();
            this.appleDataBox.setVersion(0);
            this.appleDataBox.setFlags(0);
            this.appleDataBox.setFourBytes(new byte[4]);
            this.appleDataBox.setData(AbstractAppleMetaDataBox.hexStringToByteArray(string));
        } else {
            LOG.warning("Don't know how to handle appleDataBox with flag=" + this.appleDataBox.getFlags());
        }
    }

    public String getValue() {
        if (this.appleDataBox.getFlags() == 1) {
            return Utf8.convert(this.appleDataBox.getData());
        }
        if (this.appleDataBox.getFlags() == 21) {
            byte[] byArray = this.appleDataBox.getData();
            long l = 0L;
            int n = 1;
            int n2 = byArray.length;
            for (byte by : byArray) {
                l += AbstractAppleMetaDataBox.toLong(by) << 8 * (n2 - n++);
            }
            return "" + l;
        }
        if (this.appleDataBox.getFlags() == 0) {
            return String.format("%x", new BigInteger(this.appleDataBox.getData()));
        }
        return "unknown";
    }

    public static byte[] hexStringToByteArray(String string) {
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return byArray;
    }
}

