/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4.boxes.apple;

import com.frostwire.mp4.AbstractFullBox;
import java.nio.ByteBuffer;

public final class AppleDataBox
extends AbstractFullBox {
    public static final String TYPE = "data";
    private byte[] fourBytes = new byte[4];
    private byte[] data;

    private static AppleDataBox getEmpty() {
        AppleDataBox appleDataBox = new AppleDataBox();
        appleDataBox.setVersion(0);
        appleDataBox.setFourBytes(new byte[4]);
        return appleDataBox;
    }

    public static AppleDataBox getStringAppleDataBox() {
        AppleDataBox appleDataBox = AppleDataBox.getEmpty();
        appleDataBox.setFlags(1);
        appleDataBox.setData(new byte[]{0});
        return appleDataBox;
    }

    public static AppleDataBox getUint8AppleDataBox() {
        AppleDataBox appleDataBox = new AppleDataBox();
        appleDataBox.setFlags(21);
        appleDataBox.setData(new byte[]{0});
        return appleDataBox;
    }

    public static AppleDataBox getUint16AppleDataBox() {
        AppleDataBox appleDataBox = new AppleDataBox();
        appleDataBox.setFlags(21);
        appleDataBox.setData(new byte[]{0, 0});
        return appleDataBox;
    }

    public static AppleDataBox getUint32AppleDataBox() {
        AppleDataBox appleDataBox = new AppleDataBox();
        appleDataBox.setFlags(21);
        appleDataBox.setData(new byte[]{0, 0, 0, 0});
        return appleDataBox;
    }

    public AppleDataBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        return this.data.length + 8;
    }

    public void setData(byte[] byArray) {
        this.data = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.data, 0, byArray.length);
    }

    public void setFourBytes(byte[] byArray) {
        System.arraycopy(byArray, 0, this.fourBytes, 0, 4);
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.fourBytes = new byte[4];
        byteBuffer.get(this.fourBytes);
        this.data = new byte[byteBuffer.remaining()];
        byteBuffer.get(this.data);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        byteBuffer.put(this.fourBytes, 0, 4);
        byteBuffer.put(this.data);
    }

    public byte[] getFourBytes() {
        return this.fourBytes;
    }

    public byte[] getData() {
        return this.data;
    }
}

