/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4.boxes.apple;

import com.frostwire.mp4.AbstractFullBox;
import com.frostwire.mp4.IsoTypeReader;
import com.frostwire.mp4.Utf8;
import java.nio.ByteBuffer;

public final class AppleNameBox
extends AbstractFullBox {
    public static final String TYPE = "name";
    private String name;

    public AppleNameBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        return 4 + Utf8.convert(this.name).length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.name = IsoTypeReader.readString(byteBuffer, byteBuffer.remaining());
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        byteBuffer.put(Utf8.convert(this.name));
    }
}

