/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4.boxes.fragment;

import com.frostwire.mp4.boxes.mp4.objectdescriptors.BitReaderBuffer;
import com.frostwire.mp4.boxes.mp4.objectdescriptors.BitWriterBuffer;
import java.nio.ByteBuffer;

public class SampleFlags {
    private int reserved;
    private int sampleDependsOn;
    private int sampleIsDependedOn;
    private int sampleHasRedundancy;
    private int samplePaddingValue;
    private boolean sampleIsDifferenceSample;
    private int sampleDegradationPriority;

    public SampleFlags() {
    }

    public SampleFlags(ByteBuffer byteBuffer) {
        BitReaderBuffer bitReaderBuffer = new BitReaderBuffer(byteBuffer);
        this.reserved = bitReaderBuffer.readBits(6);
        this.sampleDependsOn = bitReaderBuffer.readBits(2);
        this.sampleIsDependedOn = bitReaderBuffer.readBits(2);
        this.sampleHasRedundancy = bitReaderBuffer.readBits(2);
        this.samplePaddingValue = bitReaderBuffer.readBits(3);
        this.sampleIsDifferenceSample = bitReaderBuffer.readBits(1) == 1;
        this.sampleDegradationPriority = bitReaderBuffer.readBits(16);
    }

    public void getContent(ByteBuffer byteBuffer) {
        BitWriterBuffer bitWriterBuffer = new BitWriterBuffer(byteBuffer);
        bitWriterBuffer.writeBits(this.reserved, 6);
        bitWriterBuffer.writeBits(this.sampleDependsOn, 2);
        bitWriterBuffer.writeBits(this.sampleIsDependedOn, 2);
        bitWriterBuffer.writeBits(this.sampleHasRedundancy, 2);
        bitWriterBuffer.writeBits(this.samplePaddingValue, 3);
        bitWriterBuffer.writeBits(this.sampleIsDifferenceSample ? 1 : 0, 1);
        bitWriterBuffer.writeBits(this.sampleDegradationPriority, 16);
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(int n) {
        this.reserved = n;
    }

    public int getSampleDependsOn() {
        return this.sampleDependsOn;
    }

    public void setSampleDependsOn(int n) {
        this.sampleDependsOn = n;
    }

    public int getSampleIsDependedOn() {
        return this.sampleIsDependedOn;
    }

    public void setSampleIsDependedOn(int n) {
        this.sampleIsDependedOn = n;
    }

    public int getSampleHasRedundancy() {
        return this.sampleHasRedundancy;
    }

    public void setSampleHasRedundancy(int n) {
        this.sampleHasRedundancy = n;
    }

    public int getSamplePaddingValue() {
        return this.samplePaddingValue;
    }

    public void setSamplePaddingValue(int n) {
        this.samplePaddingValue = n;
    }

    public boolean isSampleIsDifferenceSample() {
        return this.sampleIsDifferenceSample;
    }

    public void setSampleIsDifferenceSample(boolean bl) {
        this.sampleIsDifferenceSample = bl;
    }

    public int getSampleDegradationPriority() {
        return this.sampleDegradationPriority;
    }

    public void setSampleDegradationPriority(int n) {
        this.sampleDegradationPriority = n;
    }

    public String toString() {
        return "SampleFlags{reserved=" + this.reserved + ", sampleDependsOn=" + this.sampleDependsOn + ", sampleHasRedundancy=" + this.sampleHasRedundancy + ", samplePaddingValue=" + this.samplePaddingValue + ", sampleIsDifferenceSample=" + this.sampleIsDifferenceSample + ", sampleDegradationPriority=" + this.sampleDegradationPriority + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SampleFlags sampleFlags = (SampleFlags)object;
        if (this.reserved != sampleFlags.reserved) {
            return false;
        }
        if (this.sampleDegradationPriority != sampleFlags.sampleDegradationPriority) {
            return false;
        }
        if (this.sampleDependsOn != sampleFlags.sampleDependsOn) {
            return false;
        }
        if (this.sampleHasRedundancy != sampleFlags.sampleHasRedundancy) {
            return false;
        }
        if (this.sampleIsDependedOn != sampleFlags.sampleIsDependedOn) {
            return false;
        }
        if (this.sampleIsDifferenceSample != sampleFlags.sampleIsDifferenceSample) {
            return false;
        }
        return this.samplePaddingValue == sampleFlags.samplePaddingValue;
    }

    public int hashCode() {
        int n = this.reserved;
        n = 31 * n + this.sampleDependsOn;
        n = 31 * n + this.sampleIsDependedOn;
        n = 31 * n + this.sampleHasRedundancy;
        n = 31 * n + this.samplePaddingValue;
        n = 31 * n + (this.sampleIsDifferenceSample ? 1 : 0);
        n = 31 * n + this.sampleDegradationPriority;
        return n;
    }
}

