/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4.boxes.fragment;

import com.frostwire.mp4.AbstractFullBox;
import com.frostwire.mp4.IsoTypeReader;
import com.frostwire.mp4.IsoTypeWriter;
import com.frostwire.mp4.boxes.fragment.SampleFlags;
import java.nio.ByteBuffer;

public class TrackExtendsBox
extends AbstractFullBox {
    public static final String TYPE = "trex";
    private long trackId;
    private long defaultSampleDescriptionIndex;
    private long defaultSampleDuration;
    private long defaultSampleSize;
    private SampleFlags defaultSampleFlags;

    public TrackExtendsBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        return 24L;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt32(byteBuffer, this.trackId);
        IsoTypeWriter.writeUInt32(byteBuffer, this.defaultSampleDescriptionIndex);
        IsoTypeWriter.writeUInt32(byteBuffer, this.defaultSampleDuration);
        IsoTypeWriter.writeUInt32(byteBuffer, this.defaultSampleSize);
        this.defaultSampleFlags.getContent(byteBuffer);
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.trackId = IsoTypeReader.readUInt32(byteBuffer);
        this.defaultSampleDescriptionIndex = IsoTypeReader.readUInt32(byteBuffer);
        this.defaultSampleDuration = IsoTypeReader.readUInt32(byteBuffer);
        this.defaultSampleSize = IsoTypeReader.readUInt32(byteBuffer);
        this.defaultSampleFlags = new SampleFlags(byteBuffer);
    }

    public long getTrackId() {
        return this.trackId;
    }

    public long getDefaultSampleDescriptionIndex() {
        return this.defaultSampleDescriptionIndex;
    }

    public long getDefaultSampleDuration() {
        return this.defaultSampleDuration;
    }

    public long getDefaultSampleSize() {
        return this.defaultSampleSize;
    }

    public SampleFlags getDefaultSampleFlags() {
        return this.defaultSampleFlags;
    }

    public String getDefaultSampleFlagsStr() {
        return this.defaultSampleFlags.toString();
    }

    public void setTrackId(long l) {
        this.trackId = l;
    }

    public void setDefaultSampleDescriptionIndex(long l) {
        this.defaultSampleDescriptionIndex = l;
    }

    public void setDefaultSampleDuration(long l) {
        this.defaultSampleDuration = l;
    }

    public void setDefaultSampleSize(long l) {
        this.defaultSampleSize = l;
    }

    public void setDefaultSampleFlags(SampleFlags sampleFlags) {
        this.defaultSampleFlags = sampleFlags;
    }
}

