/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4.boxes.fragment;

import com.frostwire.mp4.AbstractFullBox;
import com.frostwire.mp4.IsoTypeReader;
import com.frostwire.mp4.IsoTypeWriter;
import com.frostwire.mp4.boxes.fragment.SampleFlags;
import java.nio.ByteBuffer;

public class TrackFragmentHeaderBox
extends AbstractFullBox {
    public static final String TYPE = "tfhd";
    private long trackId;
    private long baseDataOffset = -1L;
    private long sampleDescriptionIndex;
    private long defaultSampleDuration = -1L;
    private long defaultSampleSize = -1L;
    private SampleFlags defaultSampleFlags;
    private boolean durationIsEmpty;

    public TrackFragmentHeaderBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        long l = 8L;
        int n = this.getFlags();
        if ((n & 1) == 1) {
            l += 8L;
        }
        if ((n & 2) == 2) {
            l += 4L;
        }
        if ((n & 8) == 8) {
            l += 4L;
        }
        if ((n & 0x10) == 16) {
            l += 4L;
        }
        if ((n & 0x20) == 32) {
            l += 4L;
        }
        return l;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt32(byteBuffer, this.trackId);
        if ((this.getFlags() & 1) == 1) {
            IsoTypeWriter.writeUInt64(byteBuffer, this.getBaseDataOffset());
        }
        if ((this.getFlags() & 2) == 2) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.getSampleDescriptionIndex());
        }
        if ((this.getFlags() & 8) == 8) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.getDefaultSampleDuration());
        }
        if ((this.getFlags() & 0x10) == 16) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.getDefaultSampleSize());
        }
        if ((this.getFlags() & 0x20) == 32) {
            this.defaultSampleFlags.getContent(byteBuffer);
        }
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.trackId = IsoTypeReader.readUInt32(byteBuffer);
        if ((this.getFlags() & 1) == 1) {
            this.baseDataOffset = IsoTypeReader.readUInt64(byteBuffer);
        }
        if ((this.getFlags() & 2) == 2) {
            this.sampleDescriptionIndex = IsoTypeReader.readUInt32(byteBuffer);
        }
        if ((this.getFlags() & 8) == 8) {
            this.defaultSampleDuration = IsoTypeReader.readUInt32(byteBuffer);
        }
        if ((this.getFlags() & 0x10) == 16) {
            this.defaultSampleSize = IsoTypeReader.readUInt32(byteBuffer);
        }
        if ((this.getFlags() & 0x20) == 32) {
            this.defaultSampleFlags = new SampleFlags(byteBuffer);
        }
        if ((this.getFlags() & 0x10000) == 65536) {
            this.durationIsEmpty = true;
        }
    }

    public boolean hasBaseDataOffset() {
        return (this.getFlags() & 1) != 0;
    }

    public long getTrackId() {
        return this.trackId;
    }

    public long getBaseDataOffset() {
        return this.baseDataOffset;
    }

    public long getSampleDescriptionIndex() {
        return this.sampleDescriptionIndex;
    }

    public long getDefaultSampleDuration() {
        return this.defaultSampleDuration;
    }

    public long getDefaultSampleSize() {
        return this.defaultSampleSize;
    }

    public SampleFlags getDefaultSampleFlags() {
        return this.defaultSampleFlags;
    }

    public boolean isDurationIsEmpty() {
        return this.durationIsEmpty;
    }

    public void setTrackId(long l) {
        this.trackId = l;
    }

    public void setBaseDataOffset(long l) {
        if (l == -1L) {
            this.setFlags(this.getFlags() & 0x7FFFFFFE);
        } else {
            this.setFlags(this.getFlags() | 1);
        }
        this.baseDataOffset = l;
    }

    public void setSampleDescriptionIndex(long l) {
        if (l == -1L) {
            this.setFlags(this.getFlags() & 0x7FFFFFFD);
        } else {
            this.setFlags(this.getFlags() | 2);
        }
        this.sampleDescriptionIndex = l;
    }

    public void setDefaultSampleDuration(long l) {
        this.setFlags(this.getFlags() | 8);
        this.defaultSampleDuration = l;
    }

    public void setDefaultSampleSize(long l) {
        this.setFlags(this.getFlags() | 0x10);
        this.defaultSampleSize = l;
    }

    public void setDefaultSampleFlags(SampleFlags sampleFlags) {
        this.setFlags(this.getFlags() | 0x20);
        this.defaultSampleFlags = sampleFlags;
    }

    public void setDurationIsEmpty(boolean bl) {
        this.setFlags(this.getFlags() | 0x10000);
        this.durationIsEmpty = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TrackFragmentHeaderBox");
        stringBuilder.append("{trackId=").append(this.trackId);
        stringBuilder.append(", baseDataOffset=").append(this.baseDataOffset);
        stringBuilder.append(", sampleDescriptionIndex=").append(this.sampleDescriptionIndex);
        stringBuilder.append(", defaultSampleDuration=").append(this.defaultSampleDuration);
        stringBuilder.append(", defaultSampleSize=").append(this.defaultSampleSize);
        stringBuilder.append(", defaultSampleFlags=").append(this.defaultSampleFlags);
        stringBuilder.append(", durationIsEmpty=").append(this.durationIsEmpty);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

