/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4.boxes.mdat;

import com.frostwire.mp4.BoxParser;
import com.frostwire.mp4.CastUtils;
import com.frostwire.mp4.ChannelHelper;
import com.frostwire.mp4.boxes.Box;
import com.frostwire.mp4.boxes.ContainerBox;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public final class MediaDataBox
implements Box {
    public static final String TYPE = "mdat";
    ContainerBox parent;
    ByteBuffer header;
    ByteBuffer content;

    @Override
    public ContainerBox getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ContainerBox containerBox) {
        this.parent = containerBox;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        this.header.rewind();
        this.content.rewind();
        writableByteChannel.write(this.header);
        writableByteChannel.write(this.content);
    }

    @Override
    public long getSize() {
        return this.header.limit() + this.content.limit();
    }

    @Override
    public void parse(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, long l, BoxParser boxParser) throws IOException {
        this.header = byteBuffer;
        if (readableByteChannel instanceof FileChannel && l > 0x100000L) {
            this.content = ((FileChannel)readableByteChannel).map(FileChannel.MapMode.READ_ONLY, ((FileChannel)readableByteChannel).position(), l);
            ((FileChannel)readableByteChannel).position(((FileChannel)readableByteChannel).position() + l);
        } else {
            this.content = ChannelHelper.readFully(readableByteChannel, CastUtils.l2i(l));
        }
    }

    public ByteBuffer getContent() {
        return this.content;
    }

    public ByteBuffer getHeader() {
        return this.header;
    }
}

