/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4.boxes.mdat;

import com.frostwire.mp4.CastUtils;
import com.frostwire.mp4.IsoFile;
import com.frostwire.mp4.boxes.Box;
import com.frostwire.mp4.boxes.ChunkOffsetBox;
import com.frostwire.mp4.boxes.SampleSizeBox;
import com.frostwire.mp4.boxes.SampleToChunkBox;
import com.frostwire.mp4.boxes.TrackBox;
import com.frostwire.mp4.boxes.fragment.MovieExtendsBox;
import com.frostwire.mp4.boxes.fragment.MovieFragmentBox;
import com.frostwire.mp4.boxes.fragment.TrackExtendsBox;
import com.frostwire.mp4.boxes.fragment.TrackFragmentBox;
import com.frostwire.mp4.boxes.fragment.TrackRunBox;
import com.frostwire.mp4.boxes.mdat.DummyMap;
import com.frostwire.mp4.boxes.mdat.MediaDataBox;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SampleList
extends AbstractList<ByteBuffer> {
    Map<Long, Long> offsets2Sizes;
    List<Long> offsetKeys = null;
    IsoFile isoFile;
    HashMap<MediaDataBox, Long> mdatStartCache = new HashMap();
    HashMap<MediaDataBox, Long> mdatEndCache = new HashMap();
    ArrayList<MediaDataBox> mdats = new ArrayList(1);

    public List<Long> getOffsetKeys() {
        if (this.offsetKeys == null) {
            ArrayList<Long> arrayList = new ArrayList<Long>(this.offsets2Sizes.size());
            for (Long l : this.offsets2Sizes.keySet()) {
                arrayList.add(l);
            }
            Collections.sort(arrayList);
            this.offsetKeys = arrayList;
        }
        return this.offsetKeys;
    }

    public SampleList(TrackBox trackBox) {
        Object object;
        long l;
        Box box2;
        this.isoFile = trackBox.getIsoFile();
        this.offsets2Sizes = new HashMap<Long, Long>();
        long l2 = 0L;
        for (Box box2 : this.isoFile.getBoxes()) {
            long l3 = box2.getSize();
            if ("mdat".equals(box2.getType())) {
                if (box2 instanceof MediaDataBox) {
                    l = l2 + (long)((MediaDataBox)box2).getHeader().limit();
                    this.mdatStartCache.put((MediaDataBox)box2, l);
                    this.mdatEndCache.put((MediaDataBox)box2, l + l3);
                    this.mdats.add((MediaDataBox)box2);
                } else {
                    throw new RuntimeException("Sample need to be in mdats and mdats need to be instanceof MediaDataBox");
                }
            }
            l2 += l3;
        }
        SampleSizeBox sampleSizeBox = trackBox.getSampleTableBox().getSampleSizeBox();
        box2 = trackBox.getSampleTableBox().getChunkOffsetBox();
        SampleToChunkBox sampleToChunkBox = trackBox.getSampleTableBox().getSampleToChunkBox();
        if (sampleToChunkBox != null && sampleToChunkBox.getEntries().size() > 0 && box2 != null && ((ChunkOffsetBox)box2).getChunkOffsets().length > 0 && sampleSizeBox != null && sampleSizeBox.getSampleCount() > 0L) {
            int n;
            long l4;
            Object object2;
            int n2;
            object = sampleToChunkBox.blowup(((ChunkOffsetBox)box2).getChunkOffsets().length);
            if (sampleSizeBox.getSampleSize() > 0L) {
                this.offsets2Sizes = new DummyMap<Long, Long>(sampleSizeBox.getSampleSize());
                l = sampleSizeBox.getSampleSize();
                for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                    object2 = object[n2];
                    l4 = ((ChunkOffsetBox)box2).getChunkOffsets()[n2];
                    n = 0;
                    while ((long)n < object2) {
                        this.offsets2Sizes.put(l4, l);
                        l4 += l;
                        ++n;
                    }
                }
            } else {
                int n3 = 0;
                Object object3 = sampleSizeBox.getSampleSizes();
                for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                    object2 = object[n2];
                    l4 = ((ChunkOffsetBox)box2).getChunkOffsets()[n2];
                    n = 0;
                    while ((long)n < object2) {
                        Object object4 = object3[n3];
                        this.offsets2Sizes.put(l4, (long)object4);
                        l4 += object4;
                        ++n3;
                        ++n;
                    }
                }
            }
        }
        if ((object = trackBox.getParent().getBoxes(MovieExtendsBox.class)).size() > 0) {
            List<TrackExtendsBox> list = object.get(0).getBoxes(TrackExtendsBox.class);
            for (TrackExtendsBox trackExtendsBox : list) {
                if (trackExtendsBox.getTrackId() != trackBox.getTrackHeaderBox().getTrackId()) continue;
                for (MovieFragmentBox movieFragmentBox : trackBox.getIsoFile().getBoxes(MovieFragmentBox.class)) {
                    this.offsets2Sizes.putAll(this.getOffsets(movieFragmentBox, trackBox.getTrackHeaderBox().getTrackId()));
                }
            }
        }
    }

    @Override
    public int size() {
        return this.offsets2Sizes.size();
    }

    @Override
    public ByteBuffer get(int n) {
        Long l = this.getOffsetKeys().get(n);
        int n2 = CastUtils.l2i(this.offsets2Sizes.get(l));
        for (MediaDataBox mediaDataBox : this.mdats) {
            long l2 = this.mdatStartCache.get(mediaDataBox);
            long l3 = this.mdatEndCache.get(mediaDataBox);
            if (l2 > l || l + (long)n2 > l3) continue;
            ByteBuffer byteBuffer = mediaDataBox.getContent();
            byteBuffer.position(CastUtils.l2i(l - l2));
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer2.limit(n2);
            return byteBuffer2;
        }
        throw new RuntimeException("The sample with offset " + l + " and size " + n2 + " is NOT located within an mdat");
    }

    Map<Long, Long> getOffsets(MovieFragmentBox movieFragmentBox, long l) {
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        List<TrackFragmentBox> list = movieFragmentBox.getBoxes(TrackFragmentBox.class);
        for (TrackFragmentBox trackFragmentBox : list) {
            if (trackFragmentBox.getTrackFragmentHeaderBox().getTrackId() != l) continue;
            long l2 = trackFragmentBox.getTrackFragmentHeaderBox().hasBaseDataOffset() ? trackFragmentBox.getTrackFragmentHeaderBox().getBaseDataOffset() : movieFragmentBox.getOffset();
            for (TrackRunBox trackRunBox : trackFragmentBox.getBoxes(TrackRunBox.class)) {
                long l3 = l2 + (long)trackRunBox.getDataOffset();
                long[] lArray = trackRunBox.getSampleOffsets();
                long[] lArray2 = trackRunBox.getSampleSizes();
                for (int i = 0; i < lArray2.length; ++i) {
                    hashMap.put(lArray[i] + l3, lArray2[i]);
                }
            }
        }
        return hashMap;
    }
}

