/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4.boxes.mp4.objectdescriptors;

import com.frostwire.mp4.IsoTypeWriter;
import com.frostwire.mp4.boxes.mp4.objectdescriptors.BaseDescriptor;
import com.frostwire.mp4.boxes.mp4.objectdescriptors.BitReaderBuffer;
import com.frostwire.mp4.boxes.mp4.objectdescriptors.BitWriterBuffer;
import com.frostwire.mp4.boxes.mp4.objectdescriptors.Descriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

@Descriptor(tags={5}, objectTypeIndication=64)
public class AudioSpecificConfig
extends BaseDescriptor {
    ByteBuffer configBytes;
    long endPos;
    public static Map<Integer, Integer> samplingFrequencyIndexMap = new HashMap<Integer, Integer>();
    public static Map<Integer, String> audioObjectTypeMap = new HashMap<Integer, String>();
    int audioObjectType;
    int samplingFrequencyIndex;
    int samplingFrequency;
    int channelConfiguration;
    int extensionAudioObjectType;
    int sbrPresentFlag;
    int psPresentFlag;
    int extensionSamplingFrequencyIndex;
    int extensionSamplingFrequency;
    int extensionChannelConfiguration;
    int sacPayloadEmbedding;
    int fillBits;
    int epConfig;
    int directMapping;
    int syncExtensionType;
    int frameLengthFlag;
    int dependsOnCoreCoder;
    int coreCoderDelay;
    int extensionFlag;
    int layerNr;
    int numOfSubFrame;
    int layer_length;
    int aacSectionDataResilienceFlag;
    int aacScalefactorDataResilienceFlag;
    int aacSpectralDataResilienceFlag;
    int extensionFlag3;
    boolean gaSpecificConfig;
    int isBaseLayer;
    int paraMode;
    int paraExtensionFlag;
    int hvxcVarMode;
    int hvxcRateMode;
    int erHvxcExtensionFlag;
    int var_ScalableFlag;
    int hilnQuantMode;
    int hilnMaxNumLine;
    int hilnSampleRateCode;
    int hilnFrameLength;
    int hilnContMode;
    int hilnEnhaLayer;
    int hilnEnhaQuantMode;
    boolean parametricSpecificConfig;

    @Override
    public void parseDetail(ByteBuffer byteBuffer) throws IOException {
        this.configBytes = byteBuffer.slice();
        this.configBytes.limit(this.sizeOfInstance);
        byteBuffer.position(byteBuffer.position() + this.sizeOfInstance);
        BitReaderBuffer bitReaderBuffer = new BitReaderBuffer(this.configBytes);
        this.audioObjectType = this.getAudioObjectType(bitReaderBuffer);
        this.samplingFrequencyIndex = bitReaderBuffer.readBits(4);
        if (this.samplingFrequencyIndex == 15) {
            this.samplingFrequency = bitReaderBuffer.readBits(24);
        }
        this.channelConfiguration = bitReaderBuffer.readBits(4);
        if (this.audioObjectType == 5 || this.audioObjectType == 29) {
            this.extensionAudioObjectType = 5;
            this.sbrPresentFlag = 1;
            if (this.audioObjectType == 29) {
                this.psPresentFlag = 1;
            }
            this.extensionSamplingFrequencyIndex = bitReaderBuffer.readBits(4);
            if (this.extensionSamplingFrequencyIndex == 15) {
                this.extensionSamplingFrequency = bitReaderBuffer.readBits(24);
            }
            this.audioObjectType = this.getAudioObjectType(bitReaderBuffer);
            if (this.audioObjectType == 22) {
                this.extensionChannelConfiguration = bitReaderBuffer.readBits(4);
            }
        } else {
            this.extensionAudioObjectType = 0;
        }
        switch (this.audioObjectType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                this.parseGaSpecificConfig(this.samplingFrequencyIndex, this.channelConfiguration, this.audioObjectType, bitReaderBuffer);
                break;
            }
            case 8: {
                throw new UnsupportedOperationException("can't parse CelpSpecificConfig yet");
            }
            case 9: {
                throw new UnsupportedOperationException("can't parse HvxcSpecificConfig yet");
            }
            case 12: {
                throw new UnsupportedOperationException("can't parse TTSSpecificConfig yet");
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                throw new UnsupportedOperationException("can't parse StructuredAudioSpecificConfig yet");
            }
            case 24: {
                throw new UnsupportedOperationException("can't parse ErrorResilientCelpSpecificConfig yet");
            }
            case 25: {
                throw new UnsupportedOperationException("can't parse ErrorResilientHvxcSpecificConfig yet");
            }
            case 26: 
            case 27: {
                this.parseParametricSpecificConfig(this.samplingFrequencyIndex, this.channelConfiguration, this.audioObjectType, bitReaderBuffer);
                break;
            }
            case 28: {
                throw new UnsupportedOperationException("can't parse SSCSpecificConfig yet");
            }
            case 30: {
                this.sacPayloadEmbedding = bitReaderBuffer.readBits(1);
                throw new UnsupportedOperationException("can't parse SpatialSpecificConfig yet");
            }
            case 32: 
            case 33: 
            case 34: {
                throw new UnsupportedOperationException("can't parse MPEG_1_2_SpecificConfig yet");
            }
            case 35: {
                throw new UnsupportedOperationException("can't parse DSTSpecificConfig yet");
            }
            case 36: {
                this.fillBits = bitReaderBuffer.readBits(5);
                throw new UnsupportedOperationException("can't parse ALSSpecificConfig yet");
            }
            case 37: 
            case 38: {
                throw new UnsupportedOperationException("can't parse SLSSpecificConfig yet");
            }
            case 39: {
                throw new UnsupportedOperationException("can't parse ELDSpecificConfig yet");
            }
            case 40: 
            case 41: {
                throw new UnsupportedOperationException("can't parse SymbolicMusicSpecificConfig yet");
            }
        }
        switch (this.audioObjectType) {
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 39: {
                this.epConfig = bitReaderBuffer.readBits(2);
                if (this.epConfig == 2 || this.epConfig == 3) {
                    throw new UnsupportedOperationException("can't parse ErrorProtectionSpecificConfig yet");
                }
                if (this.epConfig != 3) break;
                this.directMapping = bitReaderBuffer.readBits(1);
                if (this.directMapping != 0) break;
                throw new RuntimeException("not implemented");
            }
        }
        if (this.extensionAudioObjectType != 5 && bitReaderBuffer.remainingBits() >= 16) {
            this.syncExtensionType = bitReaderBuffer.readBits(11);
            if (this.syncExtensionType == 695) {
                this.extensionAudioObjectType = this.getAudioObjectType(bitReaderBuffer);
                if (this.extensionAudioObjectType == 5) {
                    this.sbrPresentFlag = bitReaderBuffer.readBits(1);
                    if (this.sbrPresentFlag == 1) {
                        this.extensionSamplingFrequencyIndex = bitReaderBuffer.readBits(4);
                        if (this.extensionSamplingFrequencyIndex == 15) {
                            this.extensionSamplingFrequency = bitReaderBuffer.readBits(24);
                        }
                        if (bitReaderBuffer.remainingBits() >= 12) {
                            this.syncExtensionType = bitReaderBuffer.readBits(11);
                            if (this.syncExtensionType == 1352) {
                                this.psPresentFlag = bitReaderBuffer.readBits(1);
                            }
                        }
                    }
                }
                if (this.extensionAudioObjectType == 22) {
                    this.sbrPresentFlag = bitReaderBuffer.readBits(1);
                    if (this.sbrPresentFlag == 1) {
                        this.extensionSamplingFrequencyIndex = bitReaderBuffer.readBits(4);
                        if (this.extensionSamplingFrequencyIndex == 15) {
                            this.extensionSamplingFrequency = bitReaderBuffer.readBits(24);
                        }
                    }
                    this.extensionChannelConfiguration = bitReaderBuffer.readBits(4);
                }
            }
        }
    }

    private int gaSpecificConfigSize() {
        return 0;
    }

    public int serializedSize() {
        int n = 4;
        if (this.audioObjectType != 2) {
            throw new UnsupportedOperationException("can't serialize that yet");
        }
        return n += this.gaSpecificConfigSize();
    }

    public ByteBuffer serialize() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.serializedSize());
        IsoTypeWriter.writeUInt8(byteBuffer, 5);
        IsoTypeWriter.writeUInt8(byteBuffer, this.serializedSize() - 2);
        BitWriterBuffer bitWriterBuffer = new BitWriterBuffer(byteBuffer);
        bitWriterBuffer.writeBits(this.audioObjectType, 5);
        bitWriterBuffer.writeBits(this.samplingFrequencyIndex, 4);
        if (this.samplingFrequencyIndex == 15) {
            throw new UnsupportedOperationException("can't serialize that yet");
        }
        bitWriterBuffer.writeBits(this.channelConfiguration, 4);
        return byteBuffer;
    }

    private int getAudioObjectType(BitReaderBuffer bitReaderBuffer) throws IOException {
        int n = bitReaderBuffer.readBits(5);
        if (n == 31) {
            n = 32 + bitReaderBuffer.readBits(6);
        }
        return n;
    }

    private void parseGaSpecificConfig(int n, int n2, int n3, BitReaderBuffer bitReaderBuffer) throws IOException {
        this.frameLengthFlag = bitReaderBuffer.readBits(1);
        this.dependsOnCoreCoder = bitReaderBuffer.readBits(1);
        if (this.dependsOnCoreCoder == 1) {
            this.coreCoderDelay = bitReaderBuffer.readBits(14);
        }
        this.extensionFlag = bitReaderBuffer.readBits(1);
        if (n2 == 0) {
            throw new UnsupportedOperationException("can't parse program_config_element yet");
        }
        if (n3 == 6 || n3 == 20) {
            this.layerNr = bitReaderBuffer.readBits(3);
        }
        if (this.extensionFlag == 1) {
            if (n3 == 22) {
                this.numOfSubFrame = bitReaderBuffer.readBits(5);
                this.layer_length = bitReaderBuffer.readBits(11);
            }
            if (n3 == 17 || n3 == 19 || n3 == 20 || n3 == 23) {
                this.aacSectionDataResilienceFlag = bitReaderBuffer.readBits(1);
                this.aacScalefactorDataResilienceFlag = bitReaderBuffer.readBits(1);
                this.aacSpectralDataResilienceFlag = bitReaderBuffer.readBits(1);
            }
            this.extensionFlag3 = bitReaderBuffer.readBits(1);
            if (this.extensionFlag3 == 1) {
                // empty if block
            }
        }
        this.gaSpecificConfig = true;
    }

    private void parseParametricSpecificConfig(int n, int n2, int n3, BitReaderBuffer bitReaderBuffer) throws IOException {
        this.isBaseLayer = bitReaderBuffer.readBits(1);
        if (this.isBaseLayer == 1) {
            this.parseParaConfig(n, n2, n3, bitReaderBuffer);
        } else {
            this.parseHilnEnexConfig(n, n2, n3, bitReaderBuffer);
        }
    }

    private void parseParaConfig(int n, int n2, int n3, BitReaderBuffer bitReaderBuffer) throws IOException {
        this.paraMode = bitReaderBuffer.readBits(2);
        if (this.paraMode != 1) {
            this.parseErHvxcConfig(n, n2, n3, bitReaderBuffer);
        }
        if (this.paraMode != 0) {
            this.parseHilnConfig(n, n2, n3, bitReaderBuffer);
        }
        this.paraExtensionFlag = bitReaderBuffer.readBits(1);
        this.parametricSpecificConfig = true;
    }

    private void parseErHvxcConfig(int n, int n2, int n3, BitReaderBuffer bitReaderBuffer) throws IOException {
        this.hvxcVarMode = bitReaderBuffer.readBits(1);
        this.hvxcRateMode = bitReaderBuffer.readBits(2);
        this.erHvxcExtensionFlag = bitReaderBuffer.readBits(1);
        if (this.erHvxcExtensionFlag == 1) {
            this.var_ScalableFlag = bitReaderBuffer.readBits(1);
        }
    }

    private void parseHilnConfig(int n, int n2, int n3, BitReaderBuffer bitReaderBuffer) throws IOException {
        this.hilnQuantMode = bitReaderBuffer.readBits(1);
        this.hilnMaxNumLine = bitReaderBuffer.readBits(8);
        this.hilnSampleRateCode = bitReaderBuffer.readBits(4);
        this.hilnFrameLength = bitReaderBuffer.readBits(12);
        this.hilnContMode = bitReaderBuffer.readBits(2);
    }

    private void parseHilnEnexConfig(int n, int n2, int n3, BitReaderBuffer bitReaderBuffer) throws IOException {
        this.hilnEnhaLayer = bitReaderBuffer.readBits(1);
        if (this.hilnEnhaLayer == 1) {
            this.hilnEnhaQuantMode = bitReaderBuffer.readBits(2);
        }
    }

    public ByteBuffer getConfigBytes() {
        return this.configBytes;
    }

    public int getAudioObjectType() {
        return this.audioObjectType;
    }

    public int getExtensionAudioObjectType() {
        return this.extensionAudioObjectType;
    }

    public int getSbrPresentFlag() {
        return this.sbrPresentFlag;
    }

    public int getPsPresentFlag() {
        return this.psPresentFlag;
    }

    public void setAudioObjectType(int n) {
        this.audioObjectType = n;
    }

    public void setSamplingFrequencyIndex(int n) {
        this.samplingFrequencyIndex = n;
    }

    public void setSamplingFrequency(int n) {
        this.samplingFrequency = n;
    }

    public void setChannelConfiguration(int n) {
        this.channelConfiguration = n;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AudioSpecificConfig");
        stringBuilder.append("{configBytes=").append(this.configBytes);
        stringBuilder.append(", audioObjectType=").append(this.audioObjectType).append(" (").append(audioObjectTypeMap.get(this.audioObjectType)).append(")");
        stringBuilder.append(", samplingFrequencyIndex=").append(this.samplingFrequencyIndex).append(" (").append(samplingFrequencyIndexMap.get(this.samplingFrequencyIndex)).append(")");
        stringBuilder.append(", samplingFrequency=").append(this.samplingFrequency);
        stringBuilder.append(", channelConfiguration=").append(this.channelConfiguration);
        if (this.extensionAudioObjectType > 0) {
            stringBuilder.append(", extensionAudioObjectType=").append(this.extensionAudioObjectType).append(" (").append(audioObjectTypeMap.get(this.extensionAudioObjectType)).append(")");
            stringBuilder.append(", sbrPresentFlag=").append(this.sbrPresentFlag);
            stringBuilder.append(", psPresentFlag=").append(this.psPresentFlag);
            stringBuilder.append(", extensionSamplingFrequencyIndex=").append(this.extensionSamplingFrequencyIndex).append(" (").append(samplingFrequencyIndexMap.get(this.extensionSamplingFrequencyIndex)).append(")");
            stringBuilder.append(", extensionSamplingFrequency=").append(this.extensionSamplingFrequency);
            stringBuilder.append(", extensionChannelConfiguration=").append(this.extensionChannelConfiguration);
        }
        stringBuilder.append(", syncExtensionType=").append(this.syncExtensionType);
        if (this.gaSpecificConfig) {
            stringBuilder.append(", frameLengthFlag=").append(this.frameLengthFlag);
            stringBuilder.append(", dependsOnCoreCoder=").append(this.dependsOnCoreCoder);
            stringBuilder.append(", coreCoderDelay=").append(this.coreCoderDelay);
            stringBuilder.append(", extensionFlag=").append(this.extensionFlag);
            stringBuilder.append(", layerNr=").append(this.layerNr);
            stringBuilder.append(", numOfSubFrame=").append(this.numOfSubFrame);
            stringBuilder.append(", layer_length=").append(this.layer_length);
            stringBuilder.append(", aacSectionDataResilienceFlag=").append(this.aacSectionDataResilienceFlag);
            stringBuilder.append(", aacScalefactorDataResilienceFlag=").append(this.aacScalefactorDataResilienceFlag);
            stringBuilder.append(", aacSpectralDataResilienceFlag=").append(this.aacSpectralDataResilienceFlag);
            stringBuilder.append(", extensionFlag3=").append(this.extensionFlag3);
        }
        if (this.parametricSpecificConfig) {
            stringBuilder.append(", isBaseLayer=").append(this.isBaseLayer);
            stringBuilder.append(", paraMode=").append(this.paraMode);
            stringBuilder.append(", paraExtensionFlag=").append(this.paraExtensionFlag);
            stringBuilder.append(", hvxcVarMode=").append(this.hvxcVarMode);
            stringBuilder.append(", hvxcRateMode=").append(this.hvxcRateMode);
            stringBuilder.append(", erHvxcExtensionFlag=").append(this.erHvxcExtensionFlag);
            stringBuilder.append(", var_ScalableFlag=").append(this.var_ScalableFlag);
            stringBuilder.append(", hilnQuantMode=").append(this.hilnQuantMode);
            stringBuilder.append(", hilnMaxNumLine=").append(this.hilnMaxNumLine);
            stringBuilder.append(", hilnSampleRateCode=").append(this.hilnSampleRateCode);
            stringBuilder.append(", hilnFrameLength=").append(this.hilnFrameLength);
            stringBuilder.append(", hilnContMode=").append(this.hilnContMode);
            stringBuilder.append(", hilnEnhaLayer=").append(this.hilnEnhaLayer);
            stringBuilder.append(", hilnEnhaQuantMode=").append(this.hilnEnhaQuantMode);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public int getSamplingFrequency() {
        return this.samplingFrequencyIndex == 15 ? this.samplingFrequency : samplingFrequencyIndexMap.get(this.samplingFrequencyIndex);
    }

    public int getChannelConfiguration() {
        return this.channelConfiguration;
    }

    static {
        samplingFrequencyIndexMap.put(0, 96000);
        samplingFrequencyIndexMap.put(1, 88200);
        samplingFrequencyIndexMap.put(2, 64000);
        samplingFrequencyIndexMap.put(3, 48000);
        samplingFrequencyIndexMap.put(4, 44100);
        samplingFrequencyIndexMap.put(5, 32000);
        samplingFrequencyIndexMap.put(6, 24000);
        samplingFrequencyIndexMap.put(7, 22050);
        samplingFrequencyIndexMap.put(8, 16000);
        samplingFrequencyIndexMap.put(9, 12000);
        samplingFrequencyIndexMap.put(10, 11025);
        samplingFrequencyIndexMap.put(11, 8000);
        audioObjectTypeMap.put(1, "AAC main");
        audioObjectTypeMap.put(2, "AAC LC");
        audioObjectTypeMap.put(3, "AAC SSR");
        audioObjectTypeMap.put(4, "AAC LTP");
        audioObjectTypeMap.put(5, "SBR");
        audioObjectTypeMap.put(6, "AAC Scalable");
        audioObjectTypeMap.put(7, "TwinVQ");
        audioObjectTypeMap.put(8, "CELP");
        audioObjectTypeMap.put(9, "HVXC");
        audioObjectTypeMap.put(10, "(reserved)");
        audioObjectTypeMap.put(11, "(reserved)");
        audioObjectTypeMap.put(12, "TTSI");
        audioObjectTypeMap.put(13, "Main synthetic");
        audioObjectTypeMap.put(14, "Wavetable synthesis");
        audioObjectTypeMap.put(15, "General MIDI");
        audioObjectTypeMap.put(16, "Algorithmic Synthesis and Audio FX");
        audioObjectTypeMap.put(17, "ER AAC LC");
        audioObjectTypeMap.put(18, "(reserved)");
        audioObjectTypeMap.put(19, "ER AAC LTP");
        audioObjectTypeMap.put(20, "ER AAC Scalable");
        audioObjectTypeMap.put(21, "ER TwinVQ");
        audioObjectTypeMap.put(22, "ER BSAC");
        audioObjectTypeMap.put(23, "ER AAC LD");
        audioObjectTypeMap.put(24, "ER CELP");
        audioObjectTypeMap.put(25, "ER HVXC");
        audioObjectTypeMap.put(26, "ER HILN");
        audioObjectTypeMap.put(27, "ER Parametric");
        audioObjectTypeMap.put(28, "SSC");
        audioObjectTypeMap.put(29, "PS");
        audioObjectTypeMap.put(30, "MPEG Surround");
        audioObjectTypeMap.put(31, "(escape)");
        audioObjectTypeMap.put(32, "Layer-1");
        audioObjectTypeMap.put(33, "Layer-2");
        audioObjectTypeMap.put(34, "Layer-3");
        audioObjectTypeMap.put(35, "DST");
        audioObjectTypeMap.put(36, "ALS");
        audioObjectTypeMap.put(37, "SLS");
        audioObjectTypeMap.put(38, "SLS non-core");
        audioObjectTypeMap.put(39, "ER AAC ELD");
        audioObjectTypeMap.put(40, "SMR Simple");
        audioObjectTypeMap.put(41, "SMR Main");
    }
}

