/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4.boxes.mp4.objectdescriptors;

import com.frostwire.mp4.IsoTypeReader;
import com.frostwire.mp4.boxes.mp4.objectdescriptors.Descriptor;
import java.io.IOException;
import java.nio.ByteBuffer;

@Descriptor(tags={0})
public abstract class BaseDescriptor {
    int tag;
    int sizeOfInstance;
    int sizeBytes;

    public int getTag() {
        return this.tag;
    }

    public int getSize() {
        return this.sizeOfInstance + 1 + this.sizeBytes;
    }

    public int getSizeOfInstance() {
        return this.sizeOfInstance;
    }

    public int getSizeBytes() {
        return this.sizeBytes;
    }

    public final void parse(int n, ByteBuffer byteBuffer) throws IOException {
        this.tag = n;
        int n2 = 0;
        int n3 = IsoTypeReader.readUInt8(byteBuffer);
        ++n2;
        this.sizeOfInstance = n3 & 0x7F;
        while (n3 >>> 7 == 1) {
            n3 = IsoTypeReader.readUInt8(byteBuffer);
            ++n2;
            this.sizeOfInstance = this.sizeOfInstance << 7 | n3 & 0x7F;
        }
        this.sizeBytes = n2;
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer2.limit(this.sizeOfInstance);
        this.parseDetail(byteBuffer2);
        assert (byteBuffer2.remaining() == 0) : this.getClass().getSimpleName() + " has not been fully parsed";
        byteBuffer.position(byteBuffer.position() + this.sizeOfInstance);
    }

    public abstract void parseDetail(ByteBuffer var1) throws IOException;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BaseDescriptor");
        stringBuilder.append("{tag=").append(this.tag);
        stringBuilder.append(", sizeOfInstance=").append(this.sizeOfInstance);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

