/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4.boxes.mp4.objectdescriptors;

import java.nio.ByteBuffer;

public class BitReaderBuffer {
    private ByteBuffer buffer;
    int initialPos;
    int position;

    public BitReaderBuffer(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
        this.initialPos = byteBuffer.position();
    }

    public int readBits(int n) {
        int n2;
        int n3 = this.buffer.get(this.initialPos + this.position / 8);
        int n4 = n3 < 0 ? n3 + 256 : n3;
        int n5 = 8 - this.position % 8;
        if (n <= n5) {
            n2 = (n4 << this.position % 8 & 0xFF) >> this.position % 8 + (n5 - n);
            this.position += n;
        } else {
            int n6 = n5;
            int n7 = n - n5;
            n2 = this.readBits(n6);
            n2 <<= n7;
            n2 += this.readBits(n7);
        }
        this.buffer.position(this.initialPos + (int)Math.ceil((double)this.position / 8.0));
        return n2;
    }

    public int getPosition() {
        return this.position;
    }

    public int byteSync() {
        int n = 8 - this.position % 8;
        if (n == 8) {
            n = 0;
        }
        this.readBits(n);
        return n;
    }

    public int remainingBits() {
        return this.buffer.limit() * 8 - this.position;
    }
}

