/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4.boxes.mp4.objectdescriptors;

import com.frostwire.mp4.Hex;
import com.frostwire.mp4.IsoTypeReader;
import com.frostwire.mp4.IsoTypeWriter;
import com.frostwire.mp4.boxes.mp4.objectdescriptors.AudioSpecificConfig;
import com.frostwire.mp4.boxes.mp4.objectdescriptors.BaseDescriptor;
import com.frostwire.mp4.boxes.mp4.objectdescriptors.DecoderSpecificInfo;
import com.frostwire.mp4.boxes.mp4.objectdescriptors.Descriptor;
import com.frostwire.mp4.boxes.mp4.objectdescriptors.ObjectDescriptorFactory;
import com.frostwire.mp4.boxes.mp4.objectdescriptors.ProfileLevelIndicationDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

@Descriptor(tags={4})
public class DecoderConfigDescriptor
extends BaseDescriptor {
    private static Logger log = Logger.getLogger(DecoderConfigDescriptor.class.getName());
    int objectTypeIndication;
    int streamType;
    int upStream;
    int bufferSizeDB;
    long maxBitRate;
    long avgBitRate;
    DecoderSpecificInfo decoderSpecificInfo;
    AudioSpecificConfig audioSpecificInfo;
    List<ProfileLevelIndicationDescriptor> profileLevelIndicationDescriptors = new ArrayList<ProfileLevelIndicationDescriptor>();
    byte[] configDescriptorDeadBytes;

    @Override
    public void parseDetail(ByteBuffer byteBuffer) throws IOException {
        BaseDescriptor baseDescriptor;
        this.objectTypeIndication = IsoTypeReader.readUInt8(byteBuffer);
        int n = IsoTypeReader.readUInt8(byteBuffer);
        this.streamType = n >>> 2;
        this.upStream = n >> 1 & 1;
        this.bufferSizeDB = IsoTypeReader.readUInt24(byteBuffer);
        this.maxBitRate = IsoTypeReader.readUInt32(byteBuffer);
        this.avgBitRate = IsoTypeReader.readUInt32(byteBuffer);
        if (byteBuffer.remaining() > 2) {
            int n2;
            int n3 = byteBuffer.position();
            baseDescriptor = ObjectDescriptorFactory.createFrom(this.objectTypeIndication, byteBuffer);
            int n4 = byteBuffer.position() - n3;
            log.finer(baseDescriptor + " - DecoderConfigDescr1 read: " + n4 + ", size: " + (baseDescriptor != null ? Integer.valueOf(baseDescriptor.getSize()) : null));
            if (baseDescriptor != null && n4 < (n2 = baseDescriptor.getSize())) {
                this.configDescriptorDeadBytes = new byte[n2 - n4];
                byteBuffer.get(this.configDescriptorDeadBytes);
            }
            if (baseDescriptor instanceof DecoderSpecificInfo) {
                this.decoderSpecificInfo = (DecoderSpecificInfo)baseDescriptor;
            }
            if (baseDescriptor instanceof AudioSpecificConfig) {
                this.audioSpecificInfo = (AudioSpecificConfig)baseDescriptor;
            }
        }
        while (byteBuffer.remaining() > 2) {
            long l = byteBuffer.position();
            baseDescriptor = ObjectDescriptorFactory.createFrom(this.objectTypeIndication, byteBuffer);
            long l2 = (long)byteBuffer.position() - l;
            log.finer(baseDescriptor + " - DecoderConfigDescr2 read: " + l2 + ", size: " + (baseDescriptor != null ? Integer.valueOf(baseDescriptor.getSize()) : null));
            if (!(baseDescriptor instanceof ProfileLevelIndicationDescriptor)) continue;
            this.profileLevelIndicationDescriptors.add((ProfileLevelIndicationDescriptor)baseDescriptor);
        }
    }

    public int serializedSize() {
        return 15 + this.audioSpecificInfo.serializedSize();
    }

    public ByteBuffer serialize() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.serializedSize());
        IsoTypeWriter.writeUInt8(byteBuffer, 4);
        IsoTypeWriter.writeUInt8(byteBuffer, this.serializedSize() - 2);
        IsoTypeWriter.writeUInt8(byteBuffer, this.objectTypeIndication);
        int n = this.streamType << 2 | this.upStream << 1 | 1;
        IsoTypeWriter.writeUInt8(byteBuffer, n);
        IsoTypeWriter.writeUInt24(byteBuffer, this.bufferSizeDB);
        IsoTypeWriter.writeUInt32(byteBuffer, this.maxBitRate);
        IsoTypeWriter.writeUInt32(byteBuffer, this.avgBitRate);
        byteBuffer.put(this.audioSpecificInfo.serialize().array());
        return byteBuffer;
    }

    public DecoderSpecificInfo getDecoderSpecificInfo() {
        return this.decoderSpecificInfo;
    }

    public AudioSpecificConfig getAudioSpecificInfo() {
        return this.audioSpecificInfo;
    }

    public void setAudioSpecificInfo(AudioSpecificConfig audioSpecificConfig) {
        this.audioSpecificInfo = audioSpecificConfig;
    }

    public List<ProfileLevelIndicationDescriptor> getProfileLevelIndicationDescriptors() {
        return this.profileLevelIndicationDescriptors;
    }

    public int getObjectTypeIndication() {
        return this.objectTypeIndication;
    }

    public void setObjectTypeIndication(int n) {
        this.objectTypeIndication = n;
    }

    public int getStreamType() {
        return this.streamType;
    }

    public void setStreamType(int n) {
        this.streamType = n;
    }

    public int getUpStream() {
        return this.upStream;
    }

    public void setUpStream(int n) {
        this.upStream = n;
    }

    public int getBufferSizeDB() {
        return this.bufferSizeDB;
    }

    public void setBufferSizeDB(int n) {
        this.bufferSizeDB = n;
    }

    public long getMaxBitRate() {
        return this.maxBitRate;
    }

    public void setMaxBitRate(long l) {
        this.maxBitRate = l;
    }

    public long getAvgBitRate() {
        return this.avgBitRate;
    }

    public void setAvgBitRate(long l) {
        this.avgBitRate = l;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DecoderConfigDescriptor");
        stringBuilder.append("{objectTypeIndication=").append(this.objectTypeIndication);
        stringBuilder.append(", streamType=").append(this.streamType);
        stringBuilder.append(", upStream=").append(this.upStream);
        stringBuilder.append(", bufferSizeDB=").append(this.bufferSizeDB);
        stringBuilder.append(", maxBitRate=").append(this.maxBitRate);
        stringBuilder.append(", avgBitRate=").append(this.avgBitRate);
        stringBuilder.append(", decoderSpecificInfo=").append(this.decoderSpecificInfo);
        stringBuilder.append(", audioSpecificInfo=").append(this.audioSpecificInfo);
        stringBuilder.append(", configDescriptorDeadBytes=").append(Hex.encodeHex(this.configDescriptorDeadBytes != null ? this.configDescriptorDeadBytes : new byte[]{}));
        stringBuilder.append(", profileLevelIndicationDescriptors=").append(this.profileLevelIndicationDescriptors == null ? "null" : Arrays.asList(this.profileLevelIndicationDescriptors).toString());
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

