/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4.boxes.mp4.objectdescriptors;

import com.frostwire.mp4.IsoTypeReader;
import com.frostwire.mp4.IsoTypeWriter;
import com.frostwire.mp4.boxes.mp4.objectdescriptors.BaseDescriptor;
import com.frostwire.mp4.boxes.mp4.objectdescriptors.DecoderConfigDescriptor;
import com.frostwire.mp4.boxes.mp4.objectdescriptors.Descriptor;
import com.frostwire.mp4.boxes.mp4.objectdescriptors.ObjectDescriptorFactory;
import com.frostwire.mp4.boxes.mp4.objectdescriptors.SLConfigDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

@Descriptor(tags={3})
public class ESDescriptor
extends BaseDescriptor {
    private static Logger log = Logger.getLogger(ESDescriptor.class.getName());
    int esId;
    int streamDependenceFlag;
    int URLFlag;
    int oCRstreamFlag;
    int streamPriority;
    int URLLength = 0;
    String URLString;
    int remoteODFlag;
    int dependsOnEsId;
    int oCREsId;
    DecoderConfigDescriptor decoderConfigDescriptor;
    SLConfigDescriptor slConfigDescriptor;
    List<BaseDescriptor> otherDescriptors = new ArrayList<BaseDescriptor>();

    @Override
    public void parseDetail(ByteBuffer byteBuffer) throws IOException {
        int n;
        long l;
        BaseDescriptor baseDescriptor;
        this.esId = IsoTypeReader.readUInt16(byteBuffer);
        int n2 = IsoTypeReader.readUInt8(byteBuffer);
        this.streamDependenceFlag = n2 >>> 7;
        this.URLFlag = n2 >>> 6 & 1;
        this.oCRstreamFlag = n2 >>> 5 & 1;
        this.streamPriority = n2 & 0x1F;
        if (this.streamDependenceFlag == 1) {
            this.dependsOnEsId = IsoTypeReader.readUInt16(byteBuffer);
        }
        if (this.URLFlag == 1) {
            this.URLLength = IsoTypeReader.readUInt8(byteBuffer);
            this.URLString = IsoTypeReader.readString(byteBuffer, this.URLLength);
        }
        if (this.oCRstreamFlag == 1) {
            this.oCREsId = IsoTypeReader.readUInt16(byteBuffer);
        }
        int n3 = 1 + this.getSizeBytes() + 2 + 1 + (this.streamDependenceFlag == 1 ? 2 : 0) + (this.URLFlag == 1 ? 1 + this.URLLength : 0) + (this.oCRstreamFlag == 1 ? 2 : 0);
        int n4 = byteBuffer.position();
        if (this.getSize() > n3 + 2) {
            baseDescriptor = ObjectDescriptorFactory.createFrom(-1, byteBuffer);
            l = byteBuffer.position() - n4;
            log.finer(baseDescriptor + " - ESDescriptor1 read: " + l + ", size: " + (baseDescriptor != null ? Integer.valueOf(baseDescriptor.getSize()) : null));
            if (baseDescriptor != null) {
                n = baseDescriptor.getSize();
                byteBuffer.position(n4 + n);
                n3 += n;
            } else {
                n3 = (int)((long)n3 + l);
            }
            if (baseDescriptor instanceof DecoderConfigDescriptor) {
                this.decoderConfigDescriptor = (DecoderConfigDescriptor)baseDescriptor;
            }
        }
        n4 = byteBuffer.position();
        if (this.getSize() > n3 + 2) {
            baseDescriptor = ObjectDescriptorFactory.createFrom(-1, byteBuffer);
            l = byteBuffer.position() - n4;
            log.finer(baseDescriptor + " - ESDescriptor2 read: " + l + ", size: " + (baseDescriptor != null ? Integer.valueOf(baseDescriptor.getSize()) : null));
            if (baseDescriptor != null) {
                n = baseDescriptor.getSize();
                byteBuffer.position(n4 + n);
                n3 += n;
            } else {
                n3 = (int)((long)n3 + l);
            }
            if (baseDescriptor instanceof SLConfigDescriptor) {
                this.slConfigDescriptor = (SLConfigDescriptor)baseDescriptor;
            }
        } else {
            log.warning("SLConfigDescriptor is missing!");
        }
        while (this.getSize() - n3 > 2) {
            n4 = byteBuffer.position();
            baseDescriptor = ObjectDescriptorFactory.createFrom(-1, byteBuffer);
            l = byteBuffer.position() - n4;
            log.finer(baseDescriptor + " - ESDescriptor3 read: " + l + ", size: " + (baseDescriptor != null ? Integer.valueOf(baseDescriptor.getSize()) : null));
            if (baseDescriptor != null) {
                n = baseDescriptor.getSize();
                byteBuffer.position(n4 + n);
                n3 += n;
            } else {
                n3 = (int)((long)n3 + l);
            }
            this.otherDescriptors.add(baseDescriptor);
        }
    }

    public int serializedSize() {
        int n = 5;
        if (this.streamDependenceFlag > 0) {
            n += 2;
        }
        if (this.URLFlag > 0) {
            n += 1 + this.URLLength;
        }
        if (this.oCRstreamFlag > 0) {
            n += 2;
        }
        n += this.decoderConfigDescriptor.serializedSize();
        return n += this.slConfigDescriptor.serializedSize();
    }

    public ByteBuffer serialize() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.serializedSize());
        IsoTypeWriter.writeUInt8(byteBuffer, 3);
        IsoTypeWriter.writeUInt8(byteBuffer, this.serializedSize() - 2);
        IsoTypeWriter.writeUInt16(byteBuffer, this.esId);
        int n = this.streamDependenceFlag << 7 | this.URLFlag << 6 | this.oCRstreamFlag << 5 | this.streamPriority & 0x1F;
        IsoTypeWriter.writeUInt8(byteBuffer, n);
        if (this.streamDependenceFlag > 0) {
            IsoTypeWriter.writeUInt16(byteBuffer, this.dependsOnEsId);
        }
        if (this.URLFlag > 0) {
            IsoTypeWriter.writeUInt8(byteBuffer, this.URLLength);
            IsoTypeWriter.writeUtf8String(byteBuffer, this.URLString);
        }
        if (this.oCRstreamFlag > 0) {
            IsoTypeWriter.writeUInt16(byteBuffer, this.oCREsId);
        }
        ByteBuffer byteBuffer2 = this.decoderConfigDescriptor.serialize();
        ByteBuffer byteBuffer3 = this.slConfigDescriptor.serialize();
        byteBuffer.put(byteBuffer2.array());
        byteBuffer.put(byteBuffer3.array());
        return byteBuffer;
    }

    public DecoderConfigDescriptor getDecoderConfigDescriptor() {
        return this.decoderConfigDescriptor;
    }

    public SLConfigDescriptor getSlConfigDescriptor() {
        return this.slConfigDescriptor;
    }

    public void setDecoderConfigDescriptor(DecoderConfigDescriptor decoderConfigDescriptor) {
        this.decoderConfigDescriptor = decoderConfigDescriptor;
    }

    public void setSlConfigDescriptor(SLConfigDescriptor sLConfigDescriptor) {
        this.slConfigDescriptor = sLConfigDescriptor;
    }

    public List<BaseDescriptor> getOtherDescriptors() {
        return this.otherDescriptors;
    }

    public int getoCREsId() {
        return this.oCREsId;
    }

    public void setoCREsId(int n) {
        this.oCREsId = n;
    }

    public int getEsId() {
        return this.esId;
    }

    public void setEsId(int n) {
        this.esId = n;
    }

    public int getStreamDependenceFlag() {
        return this.streamDependenceFlag;
    }

    public void setStreamDependenceFlag(int n) {
        this.streamDependenceFlag = n;
    }

    public int getURLFlag() {
        return this.URLFlag;
    }

    public void setURLFlag(int n) {
        this.URLFlag = n;
    }

    public int getoCRstreamFlag() {
        return this.oCRstreamFlag;
    }

    public void setoCRstreamFlag(int n) {
        this.oCRstreamFlag = n;
    }

    public int getStreamPriority() {
        return this.streamPriority;
    }

    public void setStreamPriority(int n) {
        this.streamPriority = n;
    }

    public int getURLLength() {
        return this.URLLength;
    }

    public void setURLLength(int n) {
        this.URLLength = n;
    }

    public String getURLString() {
        return this.URLString;
    }

    public void setURLString(String string) {
        this.URLString = string;
    }

    public int getRemoteODFlag() {
        return this.remoteODFlag;
    }

    public void setRemoteODFlag(int n) {
        this.remoteODFlag = n;
    }

    public int getDependsOnEsId() {
        return this.dependsOnEsId;
    }

    public void setDependsOnEsId(int n) {
        this.dependsOnEsId = n;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ESDescriptor");
        stringBuilder.append("{esId=").append(this.esId);
        stringBuilder.append(", streamDependenceFlag=").append(this.streamDependenceFlag);
        stringBuilder.append(", URLFlag=").append(this.URLFlag);
        stringBuilder.append(", oCRstreamFlag=").append(this.oCRstreamFlag);
        stringBuilder.append(", streamPriority=").append(this.streamPriority);
        stringBuilder.append(", URLLength=").append(this.URLLength);
        stringBuilder.append(", URLString='").append(this.URLString).append('\'');
        stringBuilder.append(", remoteODFlag=").append(this.remoteODFlag);
        stringBuilder.append(", dependsOnEsId=").append(this.dependsOnEsId);
        stringBuilder.append(", oCREsId=").append(this.oCREsId);
        stringBuilder.append(", decoderConfigDescriptor=").append(this.decoderConfigDescriptor);
        stringBuilder.append(", slConfigDescriptor=").append(this.slConfigDescriptor);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

