/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4.boxes.sampleentry;

import com.frostwire.mp4.AbstractBox;
import com.frostwire.mp4.IsoFile;
import com.frostwire.mp4.IsoTypeReader;
import com.frostwire.mp4.IsoTypeWriter;
import java.nio.ByteBuffer;

public class AmrSpecificBox
extends AbstractBox {
    public static final String TYPE = "damr";
    private String vendor;
    private int decoderVersion;
    private int modeSet;
    private int modeChangePeriod;
    private int framesPerSample;

    public AmrSpecificBox() {
        super(TYPE);
    }

    public String getVendor() {
        return this.vendor;
    }

    public int getDecoderVersion() {
        return this.decoderVersion;
    }

    public int getModeSet() {
        return this.modeSet;
    }

    public int getModeChangePeriod() {
        return this.modeChangePeriod;
    }

    public int getFramesPerSample() {
        return this.framesPerSample;
    }

    @Override
    protected long getContentSize() {
        return 9L;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[4];
        byteBuffer.get(byArray);
        this.vendor = IsoFile.bytesToFourCC(byArray);
        this.decoderVersion = IsoTypeReader.readUInt8(byteBuffer);
        this.modeSet = IsoTypeReader.readUInt16(byteBuffer);
        this.modeChangePeriod = IsoTypeReader.readUInt8(byteBuffer);
        this.framesPerSample = IsoTypeReader.readUInt8(byteBuffer);
    }

    @Override
    public void getContent(ByteBuffer byteBuffer) {
        byteBuffer.put(IsoFile.fourCCtoBytes(this.vendor));
        IsoTypeWriter.writeUInt8(byteBuffer, this.decoderVersion);
        IsoTypeWriter.writeUInt16(byteBuffer, this.modeSet);
        IsoTypeWriter.writeUInt8(byteBuffer, this.modeChangePeriod);
        IsoTypeWriter.writeUInt8(byteBuffer, this.framesPerSample);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AmrSpecificBox[vendor=").append(this.getVendor());
        stringBuilder.append(";decoderVersion=").append(this.getDecoderVersion());
        stringBuilder.append(";modeSet=").append(this.getModeSet());
        stringBuilder.append(";modeChangePeriod=").append(this.getModeChangePeriod());
        stringBuilder.append(";framesPerSample=").append(this.getFramesPerSample());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

