/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4.boxes.sampleentry;

import com.frostwire.mp4.IsoTypeReader;
import com.frostwire.mp4.IsoTypeWriter;
import com.frostwire.mp4.Utf8;
import com.frostwire.mp4.boxes.Box;
import com.frostwire.mp4.boxes.ContainerBox;
import com.frostwire.mp4.boxes.sampleentry.SampleEntry;
import java.nio.ByteBuffer;

public class VisualSampleEntry
extends SampleEntry
implements ContainerBox {
    public static final String TYPE1 = "mp4v";
    public static final String TYPE2 = "s263";
    public static final String TYPE3 = "avc1";
    public static final String TYPE_ENCRYPTED = "encv";
    private int width;
    private int height;
    private double horizresolution;
    private double vertresolution;
    private int frameCount;
    private String compressorname;
    private int depth;
    private long[] predefined = new long[3];

    public VisualSampleEntry(String string) {
        super(string);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getHorizresolution() {
        return this.horizresolution;
    }

    public double getVertresolution() {
        return this.vertresolution;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public String getCompressorname() {
        return this.compressorname;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setCompressorname(String string) {
        this.compressorname = string;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setHorizresolution(double d) {
        this.horizresolution = d;
    }

    public void setVertresolution(double d) {
        this.vertresolution = d;
    }

    public void setFrameCount(int n) {
        this.frameCount = n;
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this._parseReservedAndDataReferenceIndex(byteBuffer);
        long l = IsoTypeReader.readUInt16(byteBuffer);
        assert (0L == l) : "reserved byte not 0";
        l = IsoTypeReader.readUInt16(byteBuffer);
        assert (0L == l) : "reserved byte not 0";
        this.predefined[0] = IsoTypeReader.readUInt32(byteBuffer);
        this.predefined[1] = IsoTypeReader.readUInt32(byteBuffer);
        this.predefined[2] = IsoTypeReader.readUInt32(byteBuffer);
        this.width = IsoTypeReader.readUInt16(byteBuffer);
        this.height = IsoTypeReader.readUInt16(byteBuffer);
        this.horizresolution = IsoTypeReader.readFixedPoint1616(byteBuffer);
        this.vertresolution = IsoTypeReader.readFixedPoint1616(byteBuffer);
        l = IsoTypeReader.readUInt32(byteBuffer);
        assert (0L == l) : "reserved byte not 0";
        this.frameCount = IsoTypeReader.readUInt16(byteBuffer);
        int n = IsoTypeReader.readUInt8(byteBuffer);
        if (n > 31) {
            System.out.println("invalid compressor name displayable data: " + n);
            n = 31;
        }
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        this.compressorname = Utf8.convert(byArray);
        if (n < 31) {
            byte[] byArray2 = new byte[31 - n];
            byteBuffer.get(byArray2);
        }
        this.depth = IsoTypeReader.readUInt16(byteBuffer);
        l = IsoTypeReader.readUInt16(byteBuffer);
        assert (65535L == l);
        this._parseChildBoxes(byteBuffer);
    }

    @Override
    protected long getContentSize() {
        long l = 78L;
        for (Box box : this.boxes) {
            l += box.getSize();
        }
        return l;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this._writeReservedAndDataReferenceIndex(byteBuffer);
        IsoTypeWriter.writeUInt16(byteBuffer, 0);
        IsoTypeWriter.writeUInt16(byteBuffer, 0);
        IsoTypeWriter.writeUInt32(byteBuffer, this.predefined[0]);
        IsoTypeWriter.writeUInt32(byteBuffer, this.predefined[1]);
        IsoTypeWriter.writeUInt32(byteBuffer, this.predefined[2]);
        IsoTypeWriter.writeUInt16(byteBuffer, this.getWidth());
        IsoTypeWriter.writeUInt16(byteBuffer, this.getHeight());
        IsoTypeWriter.writeFixedPont1616(byteBuffer, this.getHorizresolution());
        IsoTypeWriter.writeFixedPont1616(byteBuffer, this.getVertresolution());
        IsoTypeWriter.writeUInt32(byteBuffer, 0L);
        IsoTypeWriter.writeUInt16(byteBuffer, this.getFrameCount());
        IsoTypeWriter.writeUInt8(byteBuffer, Utf8.utf8StringLengthInBytes(this.getCompressorname()));
        byteBuffer.put(Utf8.convert(this.getCompressorname()));
        for (int i = Utf8.utf8StringLengthInBytes(this.getCompressorname()); i < 31; ++i) {
            byteBuffer.put((byte)0);
        }
        IsoTypeWriter.writeUInt16(byteBuffer, this.getDepth());
        IsoTypeWriter.writeUInt16(byteBuffer, 65535);
        this._writeChildBoxes(byteBuffer);
    }
}

