/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.limewire.setting.Setting;
import org.limewire.setting.SettingsGroupManager;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;

public abstract class AbstractSetting
implements Setting {
    protected final Properties DEFAULT_PROPS;
    protected final Properties PROPS;
    protected final String KEY;
    protected final String DEFAULT_VALUE;
    private boolean alwaysSave = false;
    private boolean isPrivate = false;
    private Collection<SettingListener> listeners = null;

    protected AbstractSetting(Properties properties, Properties properties2, String string, String string2) {
        this.DEFAULT_PROPS = properties;
        this.PROPS = properties2;
        this.KEY = string;
        this.DEFAULT_VALUE = string2;
        if (this.DEFAULT_PROPS.containsKey(string)) {
            throw new IllegalArgumentException("(AbstractSetting constructor) duplicate setting key: " + string);
        }
        this.DEFAULT_PROPS.put(this.KEY, string2);
        this.loadValue(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSettingListener(SettingListener settingListener) {
        if (settingListener == null) {
            throw new NullPointerException("SettingListener is null");
        }
        AbstractSetting abstractSetting = this;
        synchronized (abstractSetting) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<SettingListener>();
            }
            this.listeners.add(settingListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSettingListener(SettingListener settingListener) {
        if (settingListener == null) {
            throw new NullPointerException("SettingListener is null");
        }
        AbstractSetting abstractSetting = this;
        synchronized (abstractSetting) {
            if (this.listeners != null) {
                this.listeners.remove(settingListener);
                if (this.listeners.isEmpty()) {
                    this.listeners = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SettingListener[] getSettingListeners() {
        AbstractSetting abstractSetting = this;
        synchronized (abstractSetting) {
            if (this.listeners == null) {
                return null;
            }
            return this.listeners.toArray(new SettingListener[0]);
        }
    }

    @Override
    public void reload() {
        String string = this.PROPS.getProperty(this.KEY);
        if (string == null) {
            string = this.DEFAULT_VALUE;
        }
        if (this.isDefault()) {
            this.PROPS.setProperty(this.KEY, this.DEFAULT_VALUE);
        }
        this.loadValue(string);
        this.fireSettingEvent(SettingEvent.EventType.RELOAD);
    }

    @Override
    public boolean revertToDefault() {
        if (!this.isDefault()) {
            this.setValueInternal(this.DEFAULT_VALUE);
            this.fireSettingEvent(SettingEvent.EventType.REVERT_TO_DEFAULT);
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldAlwaysSave() {
        return this.alwaysSave;
    }

    @Override
    public AbstractSetting setAlwaysSave(boolean bl) {
        if (this.alwaysSave != bl) {
            this.alwaysSave = bl;
            this.fireSettingEvent(SettingEvent.EventType.ALWAYS_SAVE_CHANGED);
        }
        return this;
    }

    @Override
    public Setting setPrivate(boolean bl) {
        if (this.isPrivate != bl) {
            this.isPrivate = bl;
            this.fireSettingEvent(SettingEvent.EventType.PRIVACY_CHANGED);
        }
        return this;
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }

    @Override
    public boolean isDefault() {
        String string = this.PROPS.getProperty(this.KEY);
        if (string == null) {
            return true;
        }
        return string.equals(this.DEFAULT_PROPS.getProperty(this.KEY));
    }

    @Override
    public String getKey() {
        return this.KEY;
    }

    @Override
    public String getValueAsString() {
        String string = this.PROPS.getProperty(this.KEY);
        return string == null ? this.DEFAULT_VALUE : string;
    }

    protected void setValueInternal(String string) {
        String string2 = this.PROPS.getProperty(this.KEY);
        if (string2 == null || !string2.equals(string)) {
            this.PROPS.setProperty(this.KEY, string);
            this.loadValue(string);
            this.fireSettingEvent(SettingEvent.EventType.VALUE_CHANGED);
        }
    }

    protected abstract void loadValue(String var1);

    public String toString() {
        return this.KEY + "=" + this.getValueAsString();
    }

    protected void fireSettingEvent(SettingEvent.EventType eventType) {
        this.fireSettingEvent(new SettingEvent(eventType, this));
    }

    protected void fireSettingEvent(final SettingEvent settingEvent) {
        if (settingEvent == null) {
            throw new NullPointerException("SettingEvent is null");
        }
        final SettingListener[] settingListenerArray = this.getSettingListeners();
        if (settingListenerArray != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    for (SettingListener settingListener : settingListenerArray) {
                        settingListener.settingChanged(settingEvent);
                    }
                }
            };
            SettingsGroupManager.instance().execute(runnable);
        }
    }

    public Object getDefaultValue() {
        return this.DEFAULT_PROPS.getProperty(this.KEY);
    }
}

