/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.limewire.service.ErrorService;
import org.limewire.setting.AbstractSetting;

public final class PasswordSetting
extends AbstractSetting {
    public static final String MD5 = "MD5";
    private static final String[] ALGORITHMS = new String[]{"MD5"};
    private static final String SEPERATOR = "/";
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private String algorithm;
    private String value;

    PasswordSetting(Properties properties, Properties properties2, String string, String string2, String string3) {
        super(properties, properties2, string2, PasswordSetting.isEncrypted(string3) ? string3 : PasswordSetting.encrypt(string, string3));
        this.postInitWithAlgorithm(string);
        this.setPrivate(true);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public boolean equals(String string) {
        if (string == null) {
            return false;
        }
        if (!PasswordSetting.isEncrypted(string)) {
            string = PasswordSetting.encrypt(this.algorithm, string);
        }
        if (!string.startsWith(this.algorithm + SEPERATOR)) {
            throw new IllegalArgumentException("Algorithm mismatch");
        }
        return this.value.equalsIgnoreCase(string);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.setValueInternal(string);
    }

    @Override
    protected void loadValue(String string) {
        if (this.algorithm != null && !PasswordSetting.isEncrypted(string)) {
            this.setValue(PasswordSetting.encrypt(this.algorithm, string));
            return;
        }
        this.value = string;
    }

    private void postInitWithAlgorithm(String string) {
        this.algorithm = string;
        if (string != null && !PasswordSetting.isEncrypted(this.value)) {
            this.setValue(PasswordSetting.encrypt(string, this.value));
        }
    }

    private static boolean isEncrypted(String string) {
        for (int i = 0; i < ALGORITHMS.length; ++i) {
            if (!string.startsWith(ALGORITHMS[i] + SEPERATOR)) continue;
            return true;
        }
        return false;
    }

    private static String encrypt(String string, String string2) {
        return PasswordSetting.encrypt(string, "UTF-8", string2);
    }

    private static String encrypt(String string, String string2, String string3) {
        if (string3 == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            byte[] byArray = messageDigest.digest(string3.getBytes(string2));
            return string + SEPERATOR + PasswordSetting.toHexString(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorService.error((Throwable)unsupportedEncodingException);
            return null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            ErrorService.error((Throwable)noSuchAlgorithmException);
            return null;
        }
    }

    private static String toHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(HEX[byArray[i] >> 4 & 0xF]).append(HEX[byArray[i] & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static String toEncrypted(String string, String string2) {
        for (int i = 0; i < ALGORITHMS.length; ++i) {
            if (!ALGORITHMS[i].equals(string)) continue;
            return string + SEPERATOR + string2;
        }
        throw new IllegalArgumentException("Unknown algorithm: " + string);
    }
}

