/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.limewire.setting.AbstractSetting;

public class StringSetSetting
extends AbstractSetting {
    private Set<String> value;

    StringSetSetting(Properties properties, Properties properties2, String string, String string2) {
        super(properties, properties2, string, string2);
    }

    public synchronized Set<String> getValue() {
        return this.value;
    }

    public synchronized String[] getValueAsArray() {
        return this.value.toArray(new String[this.value.size()]);
    }

    @Override
    protected synchronized void loadValue(String string) {
        this.value = StringSetSetting.encode(string);
    }

    private static final Set<String> encode(String string) {
        if (string == null || string.length() == 0) {
            return new HashSet<String>();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int n = stringTokenizer.countTokens();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < n; ++i) {
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }

    private static final String decode(Set<String> set) {
        if (set == null || set.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : set) {
            stringBuilder.append(string).append(';');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public synchronized void setValue(Set<String> set) {
        this.setValueInternal(StringSetSetting.decode(set));
    }

    public synchronized boolean add(String string) {
        if (this.value.add(string)) {
            this.setValueInternal(StringSetSetting.decode(this.value));
            return true;
        }
        return false;
    }

    public synchronized boolean remove(String string) {
        if (this.value.remove(string)) {
            this.setValueInternal(StringSetSetting.decode(this.value));
            return true;
        }
        return false;
    }

    public synchronized boolean contains(String string) {
        return this.value.contains(string);
    }
}

