/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.auth;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.params.HttpParams;

@ThreadSafe
public final class AuthSchemeRegistry {
    @GuardedBy(value="this")
    private final Map<String, AuthSchemeFactory> registeredSchemes = new LinkedHashMap<String, AuthSchemeFactory>();

    public synchronized void register(String string, AuthSchemeFactory authSchemeFactory) {
        if (string == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        if (authSchemeFactory == null) {
            throw new IllegalArgumentException("Authentication scheme factory may not be null");
        }
        this.registeredSchemes.put(string.toLowerCase(Locale.ENGLISH), authSchemeFactory);
    }

    public synchronized void unregister(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        this.registeredSchemes.remove(string.toLowerCase(Locale.ENGLISH));
    }

    public synchronized AuthScheme getAuthScheme(String string, HttpParams httpParams) throws IllegalStateException {
        if (string == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        AuthSchemeFactory authSchemeFactory = this.registeredSchemes.get(string.toLowerCase(Locale.ENGLISH));
        if (authSchemeFactory != null) {
            return authSchemeFactory.newInstance(httpParams);
        }
        throw new IllegalStateException("Unsupported authentication scheme: " + string);
    }

    public synchronized List<String> getSchemeNames() {
        return new ArrayList<String>(this.registeredSchemes.keySet());
    }

    public synchronized void setItems(Map<String, AuthSchemeFactory> map) {
        if (map == null) {
            return;
        }
        this.registeredSchemes.clear();
        this.registeredSchemes.putAll(map);
    }
}

