/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.auth;

import java.util.Locale;
import net.jcip.annotations.Immutable;
import org.apache.http.util.LangUtils;

@Immutable
public class AuthScope {
    public static final String ANY_HOST = null;
    public static final int ANY_PORT = -1;
    public static final String ANY_REALM = null;
    public static final String ANY_SCHEME = null;
    public static final AuthScope ANY = new AuthScope(ANY_HOST, -1, ANY_REALM, ANY_SCHEME);
    private final String scheme;
    private final String realm;
    private final String host;
    private final int port;

    public AuthScope(String string, int n, String string2, String string3) {
        this.host = string == null ? ANY_HOST : string.toLowerCase(Locale.ENGLISH);
        this.port = n < 0 ? -1 : n;
        this.realm = string2 == null ? ANY_REALM : string2;
        this.scheme = string3 == null ? ANY_SCHEME : string3.toUpperCase(Locale.ENGLISH);
    }

    public AuthScope(String string, int n, String string2) {
        this(string, n, string2, ANY_SCHEME);
    }

    public AuthScope(String string, int n) {
        this(string, n, ANY_REALM, ANY_SCHEME);
    }

    public AuthScope(AuthScope authScope) {
        if (authScope == null) {
            throw new IllegalArgumentException("Scope may not be null");
        }
        this.host = authScope.getHost();
        this.port = authScope.getPort();
        this.realm = authScope.getRealm();
        this.scheme = authScope.getScheme();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int match(AuthScope authScope) {
        int n = 0;
        if (LangUtils.equals((Object)this.scheme, (Object)authScope.scheme)) {
            ++n;
        } else if (this.scheme != ANY_SCHEME && authScope.scheme != ANY_SCHEME) {
            return -1;
        }
        if (LangUtils.equals((Object)this.realm, (Object)authScope.realm)) {
            n += 2;
        } else if (this.realm != ANY_REALM && authScope.realm != ANY_REALM) {
            return -1;
        }
        if (this.port == authScope.port) {
            n += 4;
        } else if (this.port != -1 && authScope.port != -1) {
            return -1;
        }
        if (LangUtils.equals((Object)this.host, (Object)authScope.host)) {
            n += 8;
        } else if (this.host != ANY_HOST && authScope.host != ANY_HOST) {
            return -1;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof AuthScope)) {
            return super.equals(object);
        }
        AuthScope authScope = (AuthScope)object;
        return LangUtils.equals((Object)this.host, (Object)authScope.host) && this.port == authScope.port && LangUtils.equals((Object)this.realm, (Object)authScope.realm) && LangUtils.equals((Object)this.scheme, (Object)authScope.scheme);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.scheme != null) {
            stringBuffer.append(this.scheme.toUpperCase(Locale.ENGLISH));
            stringBuffer.append(' ');
        }
        if (this.realm != null) {
            stringBuffer.append('\'');
            stringBuffer.append(this.realm);
            stringBuffer.append('\'');
        } else {
            stringBuffer.append("<any realm>");
        }
        if (this.host != null) {
            stringBuffer.append('@');
            stringBuffer.append(this.host);
            if (this.port >= 0) {
                stringBuffer.append(':');
                stringBuffer.append(this.port);
            }
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 17;
        n = LangUtils.hashCode((int)n, (Object)this.host);
        n = LangUtils.hashCode((int)n, (int)this.port);
        n = LangUtils.hashCode((int)n, (Object)this.realm);
        n = LangUtils.hashCode((int)n, (Object)this.scheme);
        return n;
    }
}

