/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.params;

import net.jcip.annotations.Immutable;
import org.apache.http.params.HttpParams;

@Immutable
public class HttpClientParams {
    private HttpClientParams() {
    }

    public static boolean isRedirecting(HttpParams httpParams) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return httpParams.getBooleanParameter("http.protocol.handle-redirects", true);
    }

    public static void setRedirecting(HttpParams httpParams, boolean bl) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        httpParams.setBooleanParameter("http.protocol.handle-redirects", bl);
    }

    public static boolean isAuthenticating(HttpParams httpParams) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return httpParams.getBooleanParameter("http.protocol.handle-authentication", true);
    }

    public static void setAuthenticating(HttpParams httpParams, boolean bl) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        httpParams.setBooleanParameter("http.protocol.handle-authentication", bl);
    }

    public static String getCookiePolicy(HttpParams httpParams) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        String string = (String)httpParams.getParameter("http.protocol.cookie-policy");
        if (string == null) {
            return "best-match";
        }
        return string;
    }

    public static void setCookiePolicy(HttpParams httpParams, String string) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        httpParams.setParameter("http.protocol.cookie-policy", (Object)string);
    }
}

