/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieIdentityComparator;

@ThreadSafe
public class BasicCookieStore
implements CookieStore {
    @GuardedBy(value="this")
    private final ArrayList<Cookie> cookies = new ArrayList();
    @GuardedBy(value="this")
    private final Comparator<Cookie> cookieComparator = new CookieIdentityComparator();

    @Override
    public synchronized void addCookie(Cookie cookie) {
        if (cookie != null) {
            Iterator<Cookie> iterator = this.cookies.iterator();
            while (iterator.hasNext()) {
                if (this.cookieComparator.compare(cookie, iterator.next()) != 0) continue;
                iterator.remove();
                break;
            }
            if (!cookie.isExpired(new Date())) {
                this.cookies.add(cookie);
            }
        }
    }

    public synchronized void addCookies(Cookie[] cookieArray) {
        if (cookieArray != null) {
            for (Cookie cookie : cookieArray) {
                this.addCookie(cookie);
            }
        }
    }

    @Override
    public synchronized List<Cookie> getCookies() {
        return Collections.unmodifiableList(this.cookies);
    }

    @Override
    public synchronized boolean clearExpired(Date date) {
        if (date == null) {
            return false;
        }
        boolean bl = false;
        Iterator<Cookie> iterator = this.cookies.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isExpired(date)) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public String toString() {
        return this.cookies.toString();
    }

    @Override
    public synchronized void clear() {
        this.cookies.clear();
    }
}

