/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.params.AbstractHttpParams;
import org.apache.http.params.HttpParams;

@NotThreadSafe
public class ClientParamsStack
extends AbstractHttpParams {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected final HttpParams applicationParams;
    protected final HttpParams clientParams;
    protected final HttpParams requestParams;
    protected final HttpParams overrideParams;

    public ClientParamsStack(HttpParams httpParams, HttpParams httpParams2, HttpParams httpParams3, HttpParams httpParams4) {
        this.applicationParams = httpParams;
        this.clientParams = httpParams2;
        this.requestParams = httpParams3;
        this.overrideParams = httpParams4;
    }

    public ClientParamsStack(ClientParamsStack clientParamsStack) {
        this(clientParamsStack.getApplicationParams(), clientParamsStack.getClientParams(), clientParamsStack.getRequestParams(), clientParamsStack.getOverrideParams());
    }

    public ClientParamsStack(ClientParamsStack clientParamsStack, HttpParams httpParams, HttpParams httpParams2, HttpParams httpParams3, HttpParams httpParams4) {
        this(httpParams != null ? httpParams : clientParamsStack.getApplicationParams(), httpParams2 != null ? httpParams2 : clientParamsStack.getClientParams(), httpParams3 != null ? httpParams3 : clientParamsStack.getRequestParams(), httpParams4 != null ? httpParams4 : clientParamsStack.getOverrideParams());
    }

    public final HttpParams getApplicationParams() {
        return this.applicationParams;
    }

    public final HttpParams getClientParams() {
        return this.clientParams;
    }

    public final HttpParams getRequestParams() {
        return this.requestParams;
    }

    public final HttpParams getOverrideParams() {
        return this.overrideParams;
    }

    public Object getParameter(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter name must not be null.");
        }
        Object object = null;
        if (this.overrideParams != null) {
            object = this.overrideParams.getParameter(string);
        }
        if (object == null && this.requestParams != null) {
            object = this.requestParams.getParameter(string);
        }
        if (object == null && this.clientParams != null) {
            object = this.clientParams.getParameter(string);
        }
        if (object == null && this.applicationParams != null) {
            object = this.applicationParams.getParameter(string);
        }
        if (this.log.isDebugEnabled() && object != null) {
            this.log.debug((Object)("'" + string + "': " + object));
        }
        return object;
    }

    public HttpParams setParameter(String string, Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Setting parameters in a stack is not supported.");
    }

    public boolean removeParameter(String string) {
        throw new UnsupportedOperationException("Removing parameters in a stack is not supported.");
    }

    public HttpParams copy() {
        return this;
    }
}

