/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.net.URI;
import java.net.URISyntaxException;
import net.jcip.annotations.Immutable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.CircularRedirectException;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.client.RedirectLocations;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

@Immutable
public class DefaultRedirectHandler
implements RedirectHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String REDIRECT_LOCATIONS = "http.protocol.redirect-locations";

    @Override
    public boolean isRedirectRequested(HttpResponse httpResponse, HttpContext httpContext) {
        if (httpResponse == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        int n = httpResponse.getStatusLine().getStatusCode();
        switch (n) {
            case 301: 
            case 302: 
            case 307: {
                HttpRequest httpRequest = (HttpRequest)httpContext.getAttribute("http.request");
                String string = httpRequest.getRequestLine().getMethod();
                return string.equalsIgnoreCase("GET") || string.equalsIgnoreCase("HEAD");
            }
            case 303: {
                return true;
            }
        }
        return false;
    }

    @Override
    public URI getLocationURI(HttpResponse httpResponse, HttpContext httpContext) throws ProtocolException {
        URI uRI;
        Object object;
        Object object2;
        URI uRI2;
        if (httpResponse == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        Header header = httpResponse.getFirstHeader("location");
        if (header == null) {
            throw new ProtocolException("Received redirect response " + httpResponse.getStatusLine() + " but no location header");
        }
        String string = header.getValue();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Redirect requested to location '" + string + "'"));
        }
        try {
            uRI2 = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ProtocolException("Invalid redirect URI: " + string, (Throwable)uRISyntaxException);
        }
        HttpParams httpParams = httpResponse.getParams();
        if (!uRI2.isAbsolute()) {
            if (httpParams.isParameterTrue("http.protocol.reject-relative-redirect")) {
                throw new ProtocolException("Relative redirect location '" + uRI2 + "' not allowed");
            }
            object2 = (HttpHost)httpContext.getAttribute("http.target_host");
            if (object2 == null) {
                throw new IllegalStateException("Target host not available in the HTTP context");
            }
            object = (HttpRequest)httpContext.getAttribute("http.request");
            try {
                uRI = new URI(object.getRequestLine().getUri());
                URI uRI3 = URIUtils.rewriteURI(uRI, (HttpHost)object2, true);
                uRI2 = URIUtils.resolve(uRI3, uRI2);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ProtocolException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
            }
        }
        if (httpParams.isParameterFalse("http.protocol.allow-circular-redirects")) {
            object2 = (RedirectLocations)httpContext.getAttribute(REDIRECT_LOCATIONS);
            if (object2 == null) {
                object2 = new RedirectLocations();
                httpContext.setAttribute(REDIRECT_LOCATIONS, object2);
            }
            if (uRI2.getFragment() != null) {
                try {
                    uRI = new HttpHost(uRI2.getHost(), uRI2.getPort(), uRI2.getScheme());
                    object = URIUtils.rewriteURI(uRI2, (HttpHost)uRI, true);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new ProtocolException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
                }
            } else {
                object = uRI2;
            }
            if (((RedirectLocations)object2).contains((URI)object)) {
                throw new CircularRedirectException("Circular redirect to '" + object + "'");
            }
            ((RedirectLocations)object2).add((URI)object);
        }
        return uRI2;
    }
}

