/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn.tsccm;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpConnection;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.AbstractPoolEntry;
import org.apache.http.impl.conn.tsccm.AbstractConnPool;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.PoolEntryRequest;
import org.apache.http.impl.conn.tsccm.RouteSpecificPool;
import org.apache.http.impl.conn.tsccm.WaitingThread;
import org.apache.http.impl.conn.tsccm.WaitingThreadAborter;
import org.apache.http.params.HttpParams;

public class ConnPoolByRoute
extends AbstractConnPool {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpParams params;
    protected final ClientConnectionOperator operator;
    protected final Queue<BasicPoolEntry> freeConnections;
    protected final Queue<WaitingThread> waitingThreads;
    protected final Map<HttpRoute, RouteSpecificPool> routeToPool;

    public ConnPoolByRoute(ClientConnectionOperator clientConnectionOperator, HttpParams httpParams) {
        if (clientConnectionOperator == null) {
            throw new IllegalArgumentException("Connection operator may not be null");
        }
        this.operator = clientConnectionOperator;
        this.params = httpParams;
        this.freeConnections = this.createFreeConnQueue();
        this.waitingThreads = this.createWaitingThreadQueue();
        this.routeToPool = this.createRouteToPoolMap();
    }

    protected Queue<BasicPoolEntry> createFreeConnQueue() {
        return new LinkedList<BasicPoolEntry>();
    }

    protected Queue<WaitingThread> createWaitingThreadQueue() {
        return new LinkedList<WaitingThread>();
    }

    protected Map<HttpRoute, RouteSpecificPool> createRouteToPoolMap() {
        return new HashMap<HttpRoute, RouteSpecificPool>();
    }

    protected RouteSpecificPool newRouteSpecificPool(HttpRoute httpRoute) {
        ConnPerRoute connPerRoute = ConnManagerParams.getMaxConnectionsPerRoute(this.params);
        return new RouteSpecificPool(httpRoute, connPerRoute.getMaxForRoute(httpRoute));
    }

    protected WaitingThread newWaitingThread(Condition condition, RouteSpecificPool routeSpecificPool) {
        return new WaitingThread(condition, routeSpecificPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RouteSpecificPool getRoutePool(HttpRoute httpRoute, boolean bl) {
        RouteSpecificPool routeSpecificPool = null;
        this.poolLock.lock();
        try {
            routeSpecificPool = this.routeToPool.get(httpRoute);
            if (routeSpecificPool == null && bl) {
                routeSpecificPool = this.newRouteSpecificPool(httpRoute);
                this.routeToPool.put(httpRoute, routeSpecificPool);
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return routeSpecificPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionsInPool(HttpRoute httpRoute) {
        this.poolLock.lock();
        try {
            RouteSpecificPool routeSpecificPool = this.getRoutePool(httpRoute, false);
            int n = routeSpecificPool != null ? routeSpecificPool.getEntryCount() : 0;
            return n;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    @Override
    public PoolEntryRequest requestPoolEntry(final HttpRoute httpRoute, final Object object) {
        final WaitingThreadAborter waitingThreadAborter = new WaitingThreadAborter();
        return new PoolEntryRequest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void abortRequest() {
                ConnPoolByRoute.this.poolLock.lock();
                try {
                    waitingThreadAborter.abort();
                }
                finally {
                    ConnPoolByRoute.this.poolLock.unlock();
                }
            }

            @Override
            public BasicPoolEntry getPoolEntry(long l, TimeUnit timeUnit) throws InterruptedException, ConnectionPoolTimeoutException {
                return ConnPoolByRoute.this.getEntryBlocking(httpRoute, object, l, timeUnit, waitingThreadAborter);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BasicPoolEntry getEntryBlocking(HttpRoute httpRoute, Object object, long l, TimeUnit timeUnit, WaitingThreadAborter waitingThreadAborter) throws ConnectionPoolTimeoutException, InterruptedException {
        int n = ConnManagerParams.getMaxTotalConnections(this.params);
        Date date = null;
        if (l > 0L) {
            date = new Date(System.currentTimeMillis() + timeUnit.toMillis(l));
        }
        BasicPoolEntry basicPoolEntry = null;
        this.poolLock.lock();
        try {
            RouteSpecificPool routeSpecificPool = this.getRoutePool(httpRoute, true);
            WaitingThread waitingThread = null;
            while (basicPoolEntry == null) {
                boolean bl;
                if (this.isShutDown) {
                    throw new IllegalStateException("Connection pool shut down.");
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Total connections kept alive: " + this.freeConnections.size()));
                    this.log.debug((Object)("Total issued connections: " + this.leasedConnections.size()));
                    this.log.debug((Object)("Total allocated connection: " + this.numConnections + " out of " + n));
                }
                if ((basicPoolEntry = this.getFreeEntry(routeSpecificPool, object)) != null) {
                    break;
                }
                boolean bl2 = bl = routeSpecificPool.getCapacity() > 0;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Available capacity: " + routeSpecificPool.getCapacity() + " out of " + routeSpecificPool.getMaxEntries() + " [" + httpRoute + "][" + object + "]"));
                }
                if (bl && this.numConnections < n) {
                    basicPoolEntry = this.createEntry(routeSpecificPool, this.operator);
                    continue;
                }
                if (bl && !this.freeConnections.isEmpty()) {
                    this.deleteLeastUsedEntry();
                    basicPoolEntry = this.createEntry(routeSpecificPool, this.operator);
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Need to wait for connection [" + httpRoute + "][" + object + "]"));
                }
                if (waitingThread == null) {
                    waitingThread = this.newWaitingThread(this.poolLock.newCondition(), routeSpecificPool);
                    waitingThreadAborter.setWaitingThread(waitingThread);
                }
                boolean bl3 = false;
                try {
                    routeSpecificPool.queueThread(waitingThread);
                    this.waitingThreads.add(waitingThread);
                    bl3 = waitingThread.await(date);
                }
                finally {
                    routeSpecificPool.removeThread(waitingThread);
                    this.waitingThreads.remove(waitingThread);
                }
                if (bl3 || date == null || date.getTime() > System.currentTimeMillis()) continue;
                throw new ConnectionPoolTimeoutException("Timeout waiting for connection");
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return basicPoolEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeEntry(BasicPoolEntry basicPoolEntry, boolean bl, long l, TimeUnit timeUnit) {
        HttpRoute httpRoute = basicPoolEntry.getPlannedRoute();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Releasing connection [" + httpRoute + "][" + basicPoolEntry.getState() + "]"));
        }
        this.poolLock.lock();
        try {
            if (this.isShutDown) {
                this.closeConnection(basicPoolEntry.getConnection());
                return;
            }
            this.leasedConnections.remove(basicPoolEntry);
            RouteSpecificPool routeSpecificPool = this.getRoutePool(httpRoute, true);
            if (bl) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Pooling connection [" + httpRoute + "][" + basicPoolEntry.getState() + "]" + "; keep alive for " + l + " " + timeUnit.toString()));
                }
                routeSpecificPool.freeEntry(basicPoolEntry);
                this.freeConnections.add(basicPoolEntry);
                this.idleConnHandler.add((HttpConnection)basicPoolEntry.getConnection(), l, timeUnit);
            } else {
                routeSpecificPool.dropEntry();
                --this.numConnections;
            }
            this.notifyWaitingThread(routeSpecificPool);
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BasicPoolEntry getFreeEntry(RouteSpecificPool routeSpecificPool, Object object) {
        BasicPoolEntry basicPoolEntry = null;
        this.poolLock.lock();
        try {
            boolean bl = false;
            while (!bl) {
                basicPoolEntry = routeSpecificPool.allocEntry(object);
                if (basicPoolEntry != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Getting free connection [" + routeSpecificPool.getRoute() + "][" + object + "]"));
                    }
                    this.freeConnections.remove(basicPoolEntry);
                    boolean bl2 = this.idleConnHandler.remove((HttpConnection)basicPoolEntry.getConnection());
                    if (!bl2) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Closing expired free connection [" + routeSpecificPool.getRoute() + "][" + object + "]"));
                        }
                        this.closeConnection(basicPoolEntry.getConnection());
                        routeSpecificPool.dropEntry();
                        --this.numConnections;
                        continue;
                    }
                    this.leasedConnections.add(basicPoolEntry);
                    bl = true;
                    continue;
                }
                bl = true;
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("No free connections [" + routeSpecificPool.getRoute() + "][" + object + "]"));
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return basicPoolEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BasicPoolEntry createEntry(RouteSpecificPool routeSpecificPool, ClientConnectionOperator clientConnectionOperator) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Creating new connection [" + routeSpecificPool.getRoute() + "]"));
        }
        BasicPoolEntry basicPoolEntry = new BasicPoolEntry(clientConnectionOperator, routeSpecificPool.getRoute());
        this.poolLock.lock();
        try {
            routeSpecificPool.createdEntry(basicPoolEntry);
            ++this.numConnections;
            this.leasedConnections.add(basicPoolEntry);
        }
        finally {
            this.poolLock.unlock();
        }
        return basicPoolEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteEntry(BasicPoolEntry basicPoolEntry) {
        HttpRoute httpRoute = basicPoolEntry.getPlannedRoute();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Deleting connection [" + httpRoute + "][" + basicPoolEntry.getState() + "]"));
        }
        this.poolLock.lock();
        try {
            this.closeConnection(basicPoolEntry.getConnection());
            RouteSpecificPool routeSpecificPool = this.getRoutePool(httpRoute, true);
            routeSpecificPool.deleteEntry(basicPoolEntry);
            --this.numConnections;
            if (routeSpecificPool.isUnused()) {
                this.routeToPool.remove(httpRoute);
            }
            this.idleConnHandler.remove((HttpConnection)basicPoolEntry.getConnection());
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteLeastUsedEntry() {
        try {
            this.poolLock.lock();
            BasicPoolEntry basicPoolEntry = this.freeConnections.remove();
            if (basicPoolEntry != null) {
                this.deleteEntry(basicPoolEntry);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"No free connection to delete.");
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleLostEntry(HttpRoute httpRoute) {
        this.poolLock.lock();
        try {
            RouteSpecificPool routeSpecificPool = this.getRoutePool(httpRoute, true);
            routeSpecificPool.dropEntry();
            if (routeSpecificPool.isUnused()) {
                this.routeToPool.remove(httpRoute);
            }
            --this.numConnections;
            this.notifyWaitingThread(routeSpecificPool);
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyWaitingThread(RouteSpecificPool routeSpecificPool) {
        WaitingThread waitingThread = null;
        this.poolLock.lock();
        try {
            if (routeSpecificPool != null && routeSpecificPool.hasThread()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Notifying thread waiting on pool [" + routeSpecificPool.getRoute() + "]"));
                }
                waitingThread = routeSpecificPool.nextThread();
            } else if (!this.waitingThreads.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Notifying thread waiting on any pool");
                }
                waitingThread = this.waitingThreads.remove();
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Notifying no-one, there are no waiting threads");
            }
            if (waitingThread != null) {
                waitingThread.wakeup();
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteClosedConnections() {
        this.poolLock.lock();
        try {
            Iterator iterator = this.freeConnections.iterator();
            while (iterator.hasNext()) {
                BasicPoolEntry basicPoolEntry = (BasicPoolEntry)iterator.next();
                if (basicPoolEntry.getConnection().isOpen()) continue;
                iterator.remove();
                this.deleteEntry(basicPoolEntry);
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.poolLock.lock();
        try {
            Object object;
            super.shutdown();
            Iterator iterator = this.freeConnections.iterator();
            while (iterator.hasNext()) {
                object = (BasicPoolEntry)iterator.next();
                iterator.remove();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Closing connection [" + ((BasicPoolEntry)object).getPlannedRoute() + "][" + ((AbstractPoolEntry)object).getState() + "]"));
                }
                this.closeConnection(((BasicPoolEntry)object).getConnection());
            }
            object = this.waitingThreads.iterator();
            while (object.hasNext()) {
                WaitingThread waitingThread = (WaitingThread)object.next();
                object.remove();
                waitingThread.wakeup();
            }
            this.routeToPool.clear();
        }
        finally {
            this.poolLock.unlock();
        }
    }
}

