/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.HashMap;
import java.util.Map;

public class ForgetfulHashMap<K, V>
extends HashMap<K, V> {
    private static final long serialVersionUID = 2532083688989076085L;
    private Object[] queue;
    private int next;
    private int n;

    public ForgetfulHashMap(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.queue = new Object[n];
        this.next = 0;
        this.n = n;
    }

    @Override
    public V put(K k, V v) {
        V v2 = super.put(k, v);
        if (this.queue[this.next] != null) {
            super.remove(this.queue[this.next]);
        }
        this.queue[this.next] = k;
        ++this.next;
        if (this.next >= this.n) {
            this.next = 0;
        }
        return v2;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }
}

