/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileLocker;
import org.limewire.util.OSUtils;
import org.limewire.util.ProcessUtils;
import org.limewire.util.SystemUtils;

public class FileUtils {
    private static final Log LOG = LogFactory.getLog(FileUtils.class);
    private static final CopyOnWriteArrayList<FileLocker> fileLockers = new CopyOnWriteArrayList();

    public static void writeObject(String string, Object object) throws IOException {
        FileUtils.writeObject(new File(string), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(File file, Object object) throws IOException {
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        catch (Throwable throwable) {
            FileUtils.close(objectOutputStream);
            throw throwable;
        }
        FileUtils.close(objectOutputStream);
    }

    public static Object readObject(String string) throws IOException, ClassNotFoundException {
        return FileUtils.readObject(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObject(File file) throws IOException, ClassNotFoundException {
        Object object;
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            object = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            FileUtils.close(objectInputStream);
            throw throwable;
        }
        FileUtils.close(objectInputStream);
        return object;
    }

    public static String getCanonicalPath(File file) throws IOException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            if (OSUtils.isWindows() && string != null && string.indexOf("There are no more files") != -1) {
                return file.getAbsolutePath();
            }
            throw iOException;
        }
    }

    public static File getCanonicalFile(File file) throws IOException {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            if (OSUtils.isWindows() && string != null && string.indexOf("There are no more files") != -1) {
                return file.getAbsoluteFile();
            }
            throw iOException;
        }
    }

    public static final boolean isAncestor(File file, File file2) {
        while (file2 != null) {
            if (file2.equals(file)) {
                return true;
            }
            file2 = file2.getParentFile();
        }
        return false;
    }

    public static final boolean isReallyParent(File file, File file2) throws IOException {
        String string;
        String string2 = FileUtils.getCanonicalPath(file);
        return string2.equals(string = FileUtils.getCanonicalPath(file2.getAbsoluteFile().getParentFile()));
    }

    public static final boolean isReallyInParentPath(File file, File file2) throws IOException {
        String string = FileUtils.getCanonicalPath(file);
        File file3 = file2.getAbsoluteFile().getParentFile();
        if (file3 == null) {
            file3 = file2.getAbsoluteFile();
        }
        String string2 = FileUtils.getCanonicalPath(file3);
        return string2.startsWith(string);
    }

    public static String getFileExtension(File file) {
        String string = file.getName();
        return FileUtils.getFileExtension(string);
    }

    public static String getFileExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return null;
        }
        if (n == 0) {
            return null;
        }
        if (n == string.length() - 1) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static boolean setWriteable(File file) {
        String string;
        if (!file.exists()) {
            return true;
        }
        if (file.canWrite()) {
            if (OSUtils.isWindows()) {
                return true;
            }
            if (!file.isDirectory()) {
                return true;
            }
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getPath();
        }
        String[] stringArray = null;
        if (OSUtils.isWindows() || OSUtils.isMacOSX()) {
            SystemUtils.setWriteable(string);
        } else if (!OSUtils.isOS2()) {
            stringArray = file.isDirectory() ? new String[]{"chmod", "u+w+x", string} : new String[]{"chmod", "u+w", string};
        }
        if (stringArray != null) {
            try {
                Process process = Runtime.getRuntime().exec(stringArray);
                process.waitFor();
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return file.canWrite();
    }

    public static void addFileLocker(FileLocker fileLocker) {
        fileLockers.addIfAbsent(fileLocker);
    }

    public static void removeFileLocker(FileLocker fileLocker) {
        fileLockers.remove(fileLocker);
    }

    public static boolean forceRename(File file, File file2) {
        boolean bl = file.renameTo(file2);
        if (!bl) {
            FileLocker fileLocker;
            Iterator<FileLocker> iterator = fileLockers.iterator();
            while (!(!iterator.hasNext() || (fileLocker = iterator.next()).releaseLock(file) && (bl = file.renameTo(file2)))) {
            }
        }
        if (!bl && (bl = FileUtils.copy(file, file2))) {
            file.delete();
        }
        return bl;
    }

    public static File[] getFilesRecursive(File file, String[] stringArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        File[] fileArray = new File[]{};
        if (file.exists() && file.isDirectory()) {
            arrayList.add(file);
        }
        while (arrayList.size() > 0) {
            File file2 = (File)arrayList.remove(0);
            String[] stringArray2 = file2.list();
            for (int i = 0; stringArray2 != null && i < stringArray2.length; ++i) {
                File file3 = new File(file2, stringArray2[i]);
                if (file3.isDirectory()) {
                    arrayList.add(file3);
                    continue;
                }
                if (!file3.isFile()) continue;
                boolean bl = false;
                if (stringArray == null) {
                    bl = true;
                } else {
                    String string = FileUtils.getFileExtension(file3);
                    for (int j = 0; j < stringArray.length && string != null; ++j) {
                        if (!string.equalsIgnoreCase(stringArray[j])) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl) continue;
                arrayList2.add(file3);
            }
        }
        if (!arrayList2.isEmpty()) {
            fileArray = new File[arrayList2.size()];
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i] = (File)arrayList2.get(i);
            }
        }
        return fileArray;
    }

    public static boolean delete(File file, boolean bl) {
        if (!file.exists()) {
            return false;
        }
        if (bl) {
            if (OSUtils.isMacOSX()) {
                return FileUtils.moveToTrashOSX(file);
            }
            if (OSUtils.isWindows()) {
                return SystemUtils.recycle(file);
            }
            throw new IllegalArgumentException("OS does not support trash");
        }
        return FileUtils.deleteRecursive(file);
    }

    private static boolean moveToTrashOSX(File file) {
        try {
            String[] stringArray = FileUtils.moveToTrashCommand(file);
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            processBuilder.redirectErrorStream();
            Process process = processBuilder.start();
            ProcessUtils.consumeAllInput(process);
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            LOG.error((Object)"InterruptedException", (Throwable)interruptedException);
        }
        catch (IOException iOException) {
            LOG.error((Object)"IOException", (Throwable)iOException);
        }
        return !file.exists();
    }

    private static String[] moveToTrashCommand(File file) {
        String string = null;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            LOG.error((Object)"IOException", (Throwable)iOException);
            string = file.getAbsolutePath();
        }
        String string2 = file.isFile() ? "file" : "folder";
        String[] stringArray = new String[]{"osascript", "-e", "set unixPath to \"" + string + "\"", "-e", "set hfsPath to POSIX file unixPath", "-e", "tell application \"Finder\"", "-e", "if " + string2 + " hfsPath exists then", "-e", "move " + string2 + " hfsPath to trash", "-e", "end if", "-e", "end tell"};
        return stringArray;
    }

    public static boolean deleteRecursive(File file) {
        String string;
        try {
            string = FileUtils.getCanonicalPath(file);
        }
        catch (IOException iOException) {
            return false;
        }
        if (!file.isDirectory()) {
            return file.delete();
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                if (!FileUtils.getCanonicalPath(fileArray[i]).startsWith(string)) {
                    continue;
                }
            }
            catch (IOException iOException) {
                return false;
            }
            if (FileUtils.deleteRecursive(fileArray[i])) continue;
            return false;
        }
        return file.delete();
    }

    public static boolean conflictsAny(File file, File file2) {
        if (file.equals(file2)) {
            return true;
        }
        HashSet<File> hashSet = new HashSet<File>();
        hashSet.add(file);
        for (File file3 : FileUtils.getFilesRecursive(file, null)) {
            hashSet.add(file3);
        }
        if (hashSet.contains(file2)) {
            return true;
        }
        for (File file3 : FileUtils.getFilesRecursive(file2, null)) {
            if (!hashSet.contains(file3)) continue;
            return true;
        }
        return false;
    }

    public static long getLengthRecursive(File file) {
        if (!file.isDirectory()) {
            return file.length();
        }
        long l = 0L;
        for (File file2 : FileUtils.getFilesRecursive(file, null)) {
            l += file2.length();
        }
        return l;
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void flush(Flushable flushable) {
        if (flushable != null) {
            try {
                flushable.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static long copy(File file, long l, File file2) {
        long l2;
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            byte[] byArray = new byte[1024];
            for (l2 = l; l2 > 0L && (n = ((InputStream)bufferedInputStream).read(byArray, 0, (int)Math.min(1024L, l2))) != -1; l2 -= (long)n) {
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            FileUtils.close(bufferedInputStream);
            FileUtils.flush(bufferedOutputStream);
            FileUtils.close(bufferedOutputStream);
            catch (Throwable throwable) {
                FileUtils.close(bufferedInputStream);
                FileUtils.flush(bufferedOutputStream);
                FileUtils.close(bufferedOutputStream);
                throw throwable;
            }
        }
        FileUtils.close(bufferedInputStream);
        FileUtils.flush(bufferedOutputStream);
        FileUtils.close(bufferedOutputStream);
        return l - l2;
    }

    public static boolean copy(File file, File file2) {
        long l = file.length();
        return FileUtils.copy(file, (int)l, file2) == l;
    }

    public static File createTempFile(String string, String string2, File file) throws IOException {
        IOException iOException = null;
        for (int i = 0; i < 10; ++i) {
            try {
                return File.createTempFile(string, string2, file);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                continue;
            }
        }
        throw iOException;
    }

    public static File createTempFile(String string, String string2) throws IOException {
        IOException iOException = null;
        for (int i = 0; i < 10; ++i) {
            try {
                return File.createTempFile(string, string2);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                continue;
            }
        }
        throw iOException;
    }

    public static File getJarFromClasspath(String string) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            classLoader = FileUtils.class.getClassLoader();
        }
        if (classLoader == null) {
            return null;
        }
        return FileUtils.getJarFromClasspath(classLoader, string);
    }

    public static File getJarFromClasspath(ClassLoader classLoader, String string) {
        String string2;
        if (classLoader == null) {
            throw new IllegalArgumentException();
        }
        URL uRL = classLoader.getResource(string);
        if (uRL != null && (string2 = CommonUtils.decode(uRL.toExternalForm())) != null && string2.startsWith("jar:file:")) {
            string2 = string2.substring("jar:file:".length(), string2.length());
            string2 = string2.substring(0, string2.length() - string.length() - "!/".length());
            return new File(string2);
        }
        return null;
    }

    public static void copyDirectoryRecursively(File file, File file2) {
        if (!file2.exists()) {
            file2.mkdir();
            file2.setWritable(true);
        }
        for (File file3 : file.listFiles()) {
            if (file3.isFile()) {
                FileUtils.copy(file3, new File(file2 + File.separator + file3.getName()));
                continue;
            }
            if (!file3.isDirectory()) continue;
            FileUtils.copyDirectoryRecursively(file3, new File(file2, file3.getName()));
        }
    }

    public static boolean deleteEmptyDirectoryRecursive(File file) {
        String string;
        try {
            string = FileUtils.getCanonicalPath(file);
        }
        catch (IOException iOException) {
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        boolean bl = true;
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                if (!FileUtils.getCanonicalPath(fileArray[i]).startsWith(string)) {
                    continue;
                }
            }
            catch (IOException iOException) {
                bl = false;
            }
            if (FileUtils.deleteEmptyDirectoryRecursive(fileArray[i])) continue;
            bl = false;
        }
        return bl ? file.delete() : false;
    }
}

