/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.util.Comparator;

public class Objects {
    private Objects() {
    }

    public static <T> T nonNull(T t, String string) {
        if (t == null) {
            throw new NullPointerException("null: " + string);
        }
        return t;
    }

    public static boolean equalOrNull(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static <T extends Comparable<T>> int compareToNull(T t, T t2) {
        return Objects.compareToNull(t, t2, true);
    }

    public static <T extends Comparable<T>> int compareToNull(T t, T t2, boolean bl) {
        if (t == t2) {
            return 0;
        }
        if (t == null) {
            return bl ? -1 : 1;
        }
        if (t2 == null) {
            return bl ? 1 : -1;
        }
        return t.compareTo(t2);
    }

    public static int compareToNullIgnoreCase(String string, String string2, boolean bl) {
        if (string == string2) {
            return 0;
        }
        if (string == null) {
            return bl ? -1 : 1;
        }
        if (string2 == null) {
            return bl ? 1 : -1;
        }
        return string.compareToIgnoreCase(string2);
    }

    public static <T extends Comparable<T>> Comparator<T> getComparator(final boolean bl) {
        return new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                return Objects.compareToNull(t, t2, bl);
            }
        };
    }
}

