#include "limoo.h"
#include "limooviewer.h"

#include <QDebug>
#include <QFileInfo>
#include <QDir>

class LimooPrivate
{
public:
    LimooViewer *page;
};

Limoo::Limoo( const SAboutData & about )
    : SApplication( about )
{
    p = new LimooPrivate;
    p->page = new LimooViewer( this );
}

void Limoo::runtimeArgsEvent( const QVariantList & args )
{
    if( args.count() == 1 )
    {
        QString arg_str = args.at(0).toString();
        QFileInfo file( arg_str );
        if( file.isDir() )
        {
            p->page->add( arg_str );
        }
        else
        {
            p->page->add( file.dir().path() );
            for( int i=0 ; i<p->page->count() ; i++ )
                if( p->page->at(i)->pixmap() == arg_str )
                    p->page->at(i)->show();
        }

    }
    else
    {
        for( int i=0 ; i<args.count() ; i++ )
            p->page->add( args.at(i).toString() );
    }
}

Limoo::~Limoo()
{
    delete p;
}
