#include <QString>
#include <QStringList>
#include <QIcon>
#include <QPixmap>

#include <SApplication>
#include <SPage>
#include <SAboutData>

#include "limoo.h"

SAboutData about_obj;

extern "C" int application( const QVariantList & args )       // Required Function <-----
{
    Limoo *limoo = new Limoo( about_obj );
        limoo->addRuntimeArgs( args );

    return 0;
}

extern "C" SAboutData about()           // Required Function <-----
{
    SAuthorInfo bardia;
        bardia.setFirstName( "Bardia" );
        bardia.setLastName( "Daneshvar" );
        bardia.setNickName( "Bardiax" );
        bardia.setAuthorIcon( QIcon(":/files/Pixs/authors/bardia-icon.jpg") );
        bardia.setAvatarPixmap( QPixmap(":/files/Pixs/authors/bardia-av.jpg") );
        bardia.setBornDate( QDate( 1990 , 9 , 18 ) );
        bardia.setHomePage( "http://www.HyperRay.net" );
        bardia.setBlog( "http://Bardiax.wordpress.com" );
        bardia.setMail( "bardia.daneshvar@gmail.com" );
        bardia.setAIM( "bardiax" );
        bardia.setGTalkIM( "bardia.daneshvar" );
        bardia.setMSN( "realbardia@live.com" );
        bardia.setSkypeIM( "bardiax" );
        bardia.setYahooIM( "bard1ax" );
        bardia.setRollList( QStringList()<<"Maintainer"<<"Developer" );
        bardia.setProgramingLanguagesList( QStringList()<<"C"<<"C++"<<"C#"<<"Qt"<<"HTML"<<"Css"<<"JavaScript" );
        bardia.setProjectsLists( QStringList() );

    about_obj.setName( "Limoo" );
    about_obj.setTranslatedName( QObject::tr("Limoo Image Viewer") );
    about_obj.setVersion( "1.1.0" );
    about_obj.setType( QList<SAboutData::Type>()<< SAboutData::Photo );
    about_obj.setCompatibleFileTypes( QStringList()<<"png"<<"jpg"<<"jpeg"<<"bmp" );
    about_obj.setIcon( QIcon(":/limoo/icon.png") );
    about_obj.setMultiRun( false );
    about_obj.setPixmap( QPixmap(":/limoo/icon.png") );
    about_obj.setLicense( Silicon::GPLLicense() );
    about_obj.setAuthors( QList<SAuthorInfo>()<<bardia );
    about_obj.setDescription( QString() + " <b>" + QObject::tr("Description :") + "</b><br /> "
                              + QObject::tr("Limoo Application can show your bmp ,png and jpg photos.") + "<br /><br /> "
                              + " <b>" + QObject::tr("Version :") + "</b> 0.3 <br /><br />"
                              + " <b>" + QObject::tr("License :") + "</b> GPL V3 <br /><br />"
                              + " <b>" + QObject::tr("Authors :") + "</b><br />"
                              + " -> Bardia Daneshvar");

    about_obj.setCommandMap( "file1 file2 ...\t\t\t Add files to thumbnail bars." );

    return about_obj;
}

