// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1

Rectangle {
    id: thumbnailbar
    color: "#00000000"

    property real cheight: 63

    property int count: 0
    property real item_padding:5

    property real itemHeight: (linear)? 123 :123
    property real itemWidth:  (linear)? 123 :123
    property int index_padding: 0

    property real previewWidth: width
    property real previewHeight: height
    property real previewX: 0
    property real previewY: 0

    property bool fancy: true

    property int on_preview : -1

    property bool linear: (on_preview != -1)
    property real list_width: (linear && virtual_width>width)?   virtual_width: width;
    property real list_height:(linear || virtual_height<height)? height : virtual_height;
    property real list_x: 0
    property real list_y: 0

    property real virtual_height: itemHeight*Math.floor( (count+index_padding-1) / items_per_line )
    property real virtual_width:  (itemWidth+item_padding)*count

    property int items_per_line: Math.floor( thumbnailbar.list_width/(thumbnailbar.itemWidth+thumbnailbar.item_padding) )


    signal preview( int index )

    Connections{
        target: View
        onWheel: {
            if( on_preview === -1 || !main.scroll_block )
                return

            if( delta < 0 )
                next()
            else
                previous()
        }
    }

    function add(){
        var component = Qt.createComponent("ThumbnailBarItem.qml");
        var item = component.createObject(thumbnailbar);
        message.visible = false
        return item
    }

    function next(){
        thumbnailbar.on_preview++
        if( thumbnailbar.on_preview == thumbnailbar.count )
            thumbnailbar.on_preview = -1

        thumbnailbar.fancy = false
        thumbnailbar.preview( thumbnailbar.on_preview )
        thumbnailbar.fancy = true
    }

    function previous(){
        if( thumbnailbar.on_preview == -1 )
            return

        thumbnailbar.fancy = false
        thumbnailbar.on_preview--
        thumbnailbar.preview( thumbnailbar.on_preview )
        thumbnailbar.fancy = true
    }

    Message {
        id: message
        text: qsTr("Please drag and drop your images here to show")
    }

    ThumbnailBarButton {
        id: prev_button
        anchors.left: thumbnailbar.left
        anchors.bottom: thumbnailbar.bottom
        text: "Previous"
        z: 101
        visible: (on_preview != -1)
        onClicked: previous()
    }

    ThumbnailBarButton {
        id: next_button
        anchors.right: thumbnailbar.right
        anchors.bottom: thumbnailbar.bottom
        text: "Next"
        z: 101
        visible: (on_preview != -1)
        onClicked: next()
    }
}
