// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1

Item {
    id: button
    width: 113
    height: 43
    anchors.margins: 3
    anchors.bottomMargin: 3 + (thumbnailbar.linear)?thumbnailbar.itemHeight:0

    property alias text: label.text

    signal clicked()

    Rectangle{
        id: back
        radius: 3
        smooth: true
        color: "#00000000"
        anchors.fill: button
    }

    Text{
        id: label
        anchors.fill: button
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        font.bold: true
        font.italic: true
        font.pointSize: 11
        color: "#ffffff"
        smooth: true
    }

    MouseArea{
        id: mousearea
        hoverEnabled: true
        anchors.fill: parent

        onClicked: button.clicked()
        onEntered: label.font.pointSize = 12.5
        onExited:  label.font.pointSize = 11
    }
}
