// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1

Item {
    id: thumbnailbar_item
    width: (selected)? (thumbnailbar.previewWidth) : (thumbnailbar.itemWidth)
    height: (selected)? (thumbnailbar.previewHeight-thumbnailbar.itemHeight) : (thumbnailbar.itemHeight)
    y:(selected)? (thumbnailbar.previewY) : ( (thumbnailbar.itemHeight+thumbnailbar.item_padding)*row + thumbnailbar.item_padding + thumbnailbar.list_y )
    x:(selected)? (thumbnailbar.previewX) : ( ( thumbnailbar.itemWidth+thumbnailbar.item_padding)*column + thumbnailbar.item_padding + thumbnailbar.list_x )
    smooth: true
    z: (selected)?100:0

    property int index: 0
    property int column: (index+index_padding) % thumbnailbar.items_per_line
    property int row:    Math.floor( (index+index_padding) / thumbnailbar.items_per_line )

    property bool selected: false
    property bool animations_on: true

    property alias source: image.src
    property alias ratio: image.ratio

    property alias text: label.text

    property real pic_framw_w: (selected)? width-350  : width-20
    property real pic_framw_h: (selected)? height-50 : height-20

    property bool linear: (!thumbnailbar.fancy && selected)

    function show(){
        selector.color = "#000000"
        selector.opacity = 0.9
        rotation = 180
        image.rotation = -180
        label.rotation = -180
        thumbnailbar_item.selected = true
    }

    function hide(){
        selector.color = Colors.highlight()
        selector.opacity = 0.1
        rotation = 0
        image.rotation = 0
        label.rotation = 0
        thumbnailbar_item.selected = false
    }

    onSelectedChanged: {
        if( thumbnailbar.on_preview !== index && thumbnailbar.on_preview !== -1 )
            return;

        thumbnailbar.on_preview = (selected)?index:-1
    }

    Connections{
        target: thumbnailbar
        onPreview: {
            if( thumbnailbar.on_preview === thumbnailbar_item.index )
                show()
            else
                hide()
        }
    }

    Behavior on x {
        NumberAnimation { easing.type: (linear)?Easing.Linear:Easing.OutBack; duration: (animations_on)? 400*Math.random() +437 : 0 }
    }
    Behavior on y {
        NumberAnimation { easing.type: (linear)?Easing.Linear:Easing.OutBack; duration: (animations_on)? 400*Math.random() +437 : 0 }
    }
    Behavior on width {
        NumberAnimation { easing.type: (linear)?Easing.Linear:Easing.OutBack; duration: (animations_on)? 400*Math.random() +437 : 0 }
    }
    Behavior on height {
        NumberAnimation { easing.type: (linear)?Easing.Linear:Easing.OutBack; duration: (animations_on)? 400*Math.random() +437 : 0 }
    }
    Behavior on rotation {
        NumberAnimation { easing.type: Easing.OutBack; duration: (animations_on && thumbnailbar.fancy)? 837 : 0 }
    }

    Rectangle {
        id: selector
        anchors.fill: parent
        color: Colors.highlight()
        radius: 4
        opacity: 0.1
        smooth: true

        Behavior on opacity {
            NumberAnimation { easing.type: Easing.Linear; duration: (animations_on)? 537 : 0 }
        }
        Behavior on color {
            ColorAnimation { easing.type: Easing.OutBack; duration: (animations_on)? 1235 : 0 }
        }
    }

    Image {
        id: image
        x: (parent.width - width)/2
        y: (parent.height - height)/2
        sourceSize.width:  (ratio>=pic_framw_w/pic_framw_h)? pic_framw_w : pic_framw_h*ratio
        sourceSize.height: (ratio<=pic_framw_w/pic_framw_h)? pic_framw_h : pic_framw_w/ratio
        smooth: true
        asynchronous: true
        cache: true

        source: (thumbnailbar_item.rotation == 180 || thumbnailbar_item.rotation == 0)? src : ""
        property string src
        property real ratio: 1
    }

    Text {
        id: label
        font.bold: true
        font.pointSize: 10
        anchors.bottom: parent.bottom
        anchors.horizontalCenter: parent.horizontalCenter
        visible: thumbnailbar_item.selected
        color: "#ffffff"
    }

    MouseArea {
        id: mousearea
        hoverEnabled: true
        anchors.fill: parent

        onEntered: {
            if( !thumbnailbar_item.selected )
                selector.opacity = 0.8
            if( thumbnailbar_item.selected )
                main.scroll_block = true
        }

        onExited: {
            if( !thumbnailbar_item.selected )
                selector.opacity = 0.1
            if( thumbnailbar_item.selected )
                main.scroll_block = false
        }

        onPressed: {
            if( thumbnailbar_item.selected )
                return

            selector.opacity = 0.9
        }

        onReleased: {
            if( thumbnailbar.on_preview !== -1 && thumbnailbar.on_preview !== index ) thumbnailbar.fancy = false

            if( thumbnailbar_item.selected )
            {
                thumbnailbar.on_preview = -1
                thumbnailbar.preview( thumbnailbar.on_preview )
            }
            else
            {
                thumbnailbar.on_preview = index
                thumbnailbar.preview( thumbnailbar.on_preview )
            }

            thumbnailbar.fancy = true
        }

        property real last_mouse_x: 0
        property real last_mouse_y: 0
    }


    Text {
        id: close_text
        text: "X"
        font.bold: true
        font.pointSize: 10
        anchors.bottom: parent.bottom
        anchors.left: parent.left
        anchors.leftMargin: 10
        anchors.bottomMargin: 7
        visible: thumbnailbar_item.selected
        color: "#ffffff"

        MouseArea {
            hoverEnabled: true
            anchors.fill: close_text

            onEntered: close_text.font.pointSize = 11
            onExited:  close_text.font.pointSize = 10
            onReleased: hide()
        }
    }
}
