// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1

Rectangle {
    id: main
    color: "#00000000"
    smooth: true

    property alias back_opacity: back.opacity
    property alias linear: thumbnailbar.linear
    property bool scroll_block: false

    Rectangle{
        id: back
        anchors.fill: parent
        color: Colors.base()
        opacity: 1.0
    }

    MouseArea{
        id: mouse_area
        anchors.fill: parent
        onClicked: View.close()
    }

    ThumbnailBar{
        id: thumbnailbar
        objectName: "thumbnailbar"
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.left: parent.left

        anchors.leftMargin: 20
        anchors.rightMargin: 20
        anchors.topMargin: 20
        anchors.bottomMargin: 20

        onOn_previewChanged: {
            if( on_preview === -1 )
                scroll_block = false
            else
                scroll_block = true
        }

        list_x: (linear)? -1*scrollbar.scrollerX*list_width/scrollbar.width : 0
        list_y: (linear)? height-itemHeight : -1*scrollbar.scrollerY*list_height/scrollbar.height
    }

    ScrollBar {
        id: scrollbar
        objectName: "scrollbar"

        y: (thumbnailbar.linear)? main.height - height : 0
        x: (thumbnailbar.linear)? 0 : main.width - width
        width: (thumbnailbar.linear)? main.width : 16
        height: (thumbnailbar.linear)? 16 : main.height

        horizontal: thumbnailbar.linear

        scrollerWidth: (thumbnailbar.linear)? thumbnailbar.previewWidth*thumbnailbar.previewWidth/thumbnailbar.list_width : 16
        scrollerHeight: (thumbnailbar.linear)? 16 : thumbnailbar.previewHeight*thumbnailbar.previewHeight/thumbnailbar.list_height

        onScrollerXChanged: {
            checkX()
        }
        onScrollerYChanged: {
            checkY()
        }

        Connections{
            target: View
            onWheel:{
                if( main.scroll_block )
                    return

                if( scrollbar.horizontal )
                    scrollbar.scrollerX += (-1*delta/120)*(thumbnailbar.itemWidth) * width / thumbnailbar.list_width;
                else
                    scrollbar.scrollerY += (-1*delta/120)*(thumbnailbar.itemHeight) * height / thumbnailbar.list_height;
            }
        }

        Connections{
            target: thumbnailbar
            onPreview: {
                if( thumbnailbar.on_preview === -1 )
                    return
                if( !scrollbar.horizontal )
                    return

                scrollbar.scrollerX = ((thumbnailbar.itemWidth+thumbnailbar.item_padding)*thumbnailbar.on_preview-width/2+thumbnailbar.itemWidth/2) * width / thumbnailbar.list_width
            }
        }

        color: "#000000"
    }

    focus: true
    Keys.onEscapePressed: View.close()
    Keys.onLeftPressed: thumbnailbar.previous()
    Keys.onRightPressed: thumbnailbar.next()

}
