#ifndef THUMBNAILBAR_H
#define THUMBNAILBAR_H

#include <QDeclarativeView>
#include <QPixmap>

class ThumbnailBarItem;
class ThumbnailBarPrivate;
class ThumbnailBar : public QDeclarativeView
{
    Q_OBJECT
public:
    ThumbnailBar( QWidget *parent = 0 );
    ~ThumbnailBar();

    ThumbnailBarItem *add( const QString & path , const QString & name );
    ThumbnailBarItem *insert( int index , const QString & path , const QString & name );
    ThumbnailBarItem *insert( int index , const QString & name );

    void remove( ThumbnailBarItem *item );
    void remove( int index );

    ThumbnailBarItem *at( int index ) const;
    int indexOf( ThumbnailBarItem *item ) const;

    int count() const;

    QObject *obj() const;

    void setBackgroundOpacity( qreal opacity );
    qreal backgroundOpacity() const;

signals:
    void closed();
    void wheel( qreal delta );

private slots:
    void itemDestroyed( QObject *obj );
    void reindex();

protected:
    void closeEvent( QCloseEvent *event );
    void wheelEvent( QWheelEvent *event );
    
private:
    ThumbnailBarPrivate *p;
};

#endif // THUMBNAILBAR_H
