#ifndef THUMBNAILBARITEM_H
#define THUMBNAILBARITEM_H

#include <QObject>
#include <QPixmap>

class ThumbnailBarItemPrivate;
class ThumbnailBarItem : public QObject
{
    Q_OBJECT

    friend class ThumbnailBar;

public:
    ~ThumbnailBarItem();

    void setText( const QString & text );
    QString text() const;

    bool setPixmap( const QString & path );
    QString pixmap() const;

    void show();
    
signals:

private slots:
    void objDestroyed();

private:
    ThumbnailBarItem( QObject *item );
    QObject *obj() const;
    
private:
    ThumbnailBarItemPrivate *p;
};

#endif // THUMBNAILBARITEM_H
