#include <QString>
#include <QStringList>
#include <QIcon>
#include <QPixmap>

#include <SApplication>
#include <SPage>
#include <SAboutData>

#include "photoviewer.h"

SAboutData about_obj;

extern "C" int application( const QVariantList & args )       // Required Function <-----
{
    SApplication *app = new SApplication( about_obj );
    PhotoViewer *photo_viewer = new PhotoViewer( about_obj.name() , app );

    if( !args.isEmpty() )
        photo_viewer->addRuntimeArgs( args );

    QObject::connect( app , SIGNAL(runtimeArguments(QVariantList)) , photo_viewer , SLOT(addRuntimeArgs(QVariantList)) );

    return 0;
}

extern "C" SAboutData about()           // Required Function <-----
{
    SAuthorInfo bardia;
        bardia.setFirstName( "Bardia" );
        bardia.setLastName( "Daneshvar" );
        bardia.setNickName( "Bardiax" );
        bardia.setAuthorIcon( QIcon(":/files/Pixs/authors/bardia-icon.jpg") );
        bardia.setAvatarPixmap( QPixmap(":/files/Pixs/authors/bardia-av.jpg") );
        bardia.setBornDate( QDate( 1990 , 9 , 18 ) );
        bardia.setHomePage( "http://www.HyperRay.net" );
        bardia.setBlog( "http://Bardiax.wordpress.com" );
        bardia.setMail( "bardia.daneshvar@gmail.com" );
        bardia.setAIM( "bardiax" );
        bardia.setGTalkIM( "bardia.daneshvar" );
        bardia.setMSN( "realbardia@live.com" );
        bardia.setSkypeIM( "bardiax" );
        bardia.setYahooIM( "bard1ax" );
        bardia.setRollList( QStringList()<<"Maintainer"<<"Developer" );
        bardia.setProgramingLanguagesList( QStringList()<<"C"<<"C++"<<"C#"<<"Qt"<<"HTML"<<"Css"<<"JavaScript" );
        bardia.setProjectsLists( QStringList() );

    about_obj.setName( "PhotoViewer" );
    about_obj.setTranslatedName( QObject::tr("Photo Viewer") );
    about_obj.setVersion( "1.1.0" );
    about_obj.setType( QList<SAboutData::Type>()<< SAboutData::Photo );
    about_obj.setCompatibleFileTypes( QStringList()<<"png"<<"jpg"<<"jpeg"<<"bmp" );
    about_obj.setIcon( QIcon(":/photo-manager/icon.png") );
    about_obj.setMultiRun( true );
    about_obj.setPixmap( QPixmap(":/photo-manager/icon.png") );
    about_obj.setLicense( Silicon::GPLLicense() );
    about_obj.setAuthors( QList<SAuthorInfo>()<<bardia );
    about_obj.setDescription( QString() + " <b>" + QObject::tr("Description :") + "</b><br /> "
                              + QObject::tr("PhotoViewer Application can show your bmp ,png and jpg photos.") + "<br /><br /> "
                              + " <b>" + QObject::tr("Version :") + "</b> 1.1.0 <br /><br />"
                              + " <b>" + QObject::tr("License :") + "</b> GPL V3 <br /><br />"
                              + " <b>" + QObject::tr("Authors :") + "</b><br />"
                              + " -> Bardia Daneshvar");

    about_obj.setCommandMap( "file1 file2 ...\t\t\t Add files to thumbnail bars." );

    return about_obj;
}

