#ifndef PHOTOVIEWER_H
#define PHOTOVIEWER_H

#include <QWidget>
#include <QObject>
#include <QString>
#include <QStringList>

#include <SPage>
#include <SApplication>
#include <STabItem>

class PhotoViewerPrivate;

class PhotoViewer : public SPage
{
    Q_OBJECT
public:
    PhotoViewer( const QString & name , SApplication *parent );
    ~PhotoViewer();

    void setupActions();

public slots:
    void showPicture( const QString & path );
    void fullScreen();
    void addRuntimeArgs( const QVariantList &args );

protected:
    void dropEvent( QDropEvent *event );
    void dragEnterEvent( QDragEnterEvent *event );

private:
    PhotoViewerPrivate *p;
};

#endif // PHOTOVIEWER_H
