#include "tagarg.h"

#include <QString>
#include <QStringList>
#include <QIcon>
#include <QPixmap>

#include <SAboutData>
#include <SApplication>

SAboutData about_obj;

extern "C" int application( const QVariantList & args )       // Required Function <-----
{
    Tagarg *sapp = new Tagarg( about_obj );
        sapp->addRuntimeArgs( args );

    return 0;
}

extern "C" SAboutData about()           // Required Function <-----
{
    SAuthorInfo bardia;
        bardia.setFirstName( "Bardia" );
        bardia.setLastName( "Daneshvar" );
        bardia.setNickName( "Bardiax" );
        bardia.setAuthorIcon( QIcon(":/files/Pixs/authors/bardia-icon.jpg") );
        bardia.setAvatarPixmap( QPixmap(":/files/Pixs/authors/bardia-av.jpg") );
        bardia.setBornDate( QDate( 1990 , 9 , 18 ) );
        bardia.setHomePage( "http://www.HyperRay.net" );
        bardia.setBlog( "http://Bardiax.wordpress.com" );
        bardia.setMail( "bardia.daneshvar@gmail.com" );
        bardia.setAIM( "bardiax" );
        bardia.setGTalkIM( "bardia.daneshvar" );
        bardia.setMSN( "realbardia@live.com" );
        bardia.setSkypeIM( "bardiax" );
        bardia.setYahooIM( "bard1ax" );
        bardia.setRollList( QStringList()<<"Maintainer"<<"Developer" );
        bardia.setProgramingLanguagesList( QStringList()<<"C"<<"C++"<<"C#"<<"Qt"<<"HTML"<<"Css"<<"JavaScript" );
        bardia.setProjectsLists( QStringList() );
        about_obj.setAuthors( QList<SAuthorInfo>()<<bardia );

    about_obj.setName( "Tagarg" );
    about_obj.setTranslatedName( QObject::tr("Music Player") );
    about_obj.setVersion( "0.5" );
    about_obj.setType( QList<SAboutData::Type>()<< SAboutData::Sound );
    about_obj.setIcon( QIcon(":/TagargPlayer/Pics/icon.png") );
    about_obj.setCompatibleFileTypes( QStringList()<<"mp3"<<"wav"<<"ogg" );
    about_obj.setMultiRun( false );
    about_obj.setPixmap( QPixmap(":/TagargPlayer/Pics/pic.png") );
    about_obj.setLicense( Silicon::LesserGPLLicense() );
    about_obj.setDescription( QString() + " <b>" + QObject::tr("Description :") + "</b><br /> "
                              + "<b>" + QObject::tr("Under Construction") + "</b><br /> "
                              + QObject::tr("Tagarg Application is a MusicPlayer that is replaced with Minitunes Silicon Edition.") + "<br /><br /> "
                              + QObject::tr("Currently some part of this application is under construction.") + "<br /> * "
                              + QObject::tr("You can select your favorties tagarg widgets from plugin system.") + "<br /><br />"
                              + " <b>" + QObject::tr("Version :") + "</b> 0.5 <br /><br />"
                              + " <b>" + QObject::tr("License :") + "</b> GPL V3 <br /><br />"
                              + " <b>" + QObject::tr("Authors :") + "</b><br />"
                              + " -> Bardia Daneshvar");

    about_obj.setCommandMap( "file1 file2 ...\t\t\t\tAdd to playlist and play.\n\n"
                             "-play\t\t\t\tPlay current item in playlist.\n\n"
                             "-previous\t\t\t\tPlay previous item in playlist.\n\n"
                             "-next\t\t\t\tPlay next item in playlist.\n\n"
                             "-stop\t\t\t\tStop playing.\n\n"
                             "-add-widget   QWidget*   (int)height   (int)[0/1]\tadd a widget to the tagarg-player with optional property for height \n\t\t\t\tand Pixel or Percent size type.\n\n"
                             "-insert-widget   int   QWidget*   (int)height   (int)[0/1]\tinsert a widget to the tagarg-player with optional property for height \n\t\t\t\tand Pixel or Percent size type.\n\n"
                             "-remove-widget   QWidget* \t\t\tremove a widget from tagarg-player.\n\n" );

    return about_obj;
}
