#define PLAYLIST_WIDTH 317

#include "mainwindow.h"
#include "playlist.h"
#include "playercore.h"

#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QStatusBar>
#include <QListWidget>

#include <SWidgetManager>
#include <SMasterIcons>

class MainWindowPrivate
{
public:
    PlayList   *playlist;
    PlayerCore *player;

    SWidgetManager *wmanager;

    QListWidget *database;

    QHBoxLayout *layout;
    QVBoxLayout *main_layout;
};

MainWindow::MainWindow( SApplication *parent ) :
    SPage( tr("Tagarg Player") , parent )
{
    p = new MainWindowPrivate;

    p->player = new PlayerCore( this );
    p->playlist = new PlayList();

    p->database = new QListWidget();
        p->database->setIconSize( QSize(32,32) );
        p->database->setSelectionMode( QAbstractItemView::NoSelection );
        p->database->setFocusPolicy( Qt::NoFocus );
        p->database->addItem( new QListWidgetItem( SMasterIcons::icon(QSize(48,48),"dialog-information.png") , tr("Under Construction\nWe will putting a list of your audio discs\nand musics on data-discs here.") ) );

    p->wmanager = new SWidgetManager();
    p->layout = new QHBoxLayout();
        p->layout->addWidget( p->database , 3 );
        p->layout->addWidget( p->wmanager , 5 );
        p->layout->addWidget( p->playlist , 3 );

    p->main_layout = new QVBoxLayout( this );
        p->main_layout->addLayout( p->layout );

    connect( p->playlist , SIGNAL(playing(QString)) , SLOT(playing(QString)) , Qt::QueuedConnection );
    connect( p->player   , SIGNAL(finished())       , SLOT(next())             );
    connect( p->player   , SIGNAL(prev())           , p->playlist , SLOT(previous()) );

    setToolBar( p->player );
    setStatusBar( 0 );
    setMinimumSize( QSize(720,350) );
}

void MainWindow::setSource( const QString & file )
{
    p->player->setSource( file );
}

void MainWindow::playing( const QString & file )
{
    for( int i=0 ; i<p->wmanager->count() ; i++ )
        QMetaObject::invokeMethod( p->wmanager->at(i), "playing", Q_ARG(QString, file) );

    p->player->setSource( file );
    p->player->play();
}

void MainWindow::addToList( const QStringList & files )
{
    p->playlist->addFiles( files );
}

void MainWindow::addToListAndPlay( const QStringList & files )
{
    p->playlist->addFilesAndPlay( files );
}

void MainWindow::insertWidget( int index , QWidget *widget , int default_height , SWidgetManager::ResizeMode mode )
{
    p->wmanager->insertWidget( index , widget , default_height , mode );
    QMetaObject::invokeMethod( widget , "init" , Q_ARG(const Phonon::AudioOutput*,p->player->audioOutput())
                                               , Q_ARG(const Phonon::MediaObject*,p->player->mediaObject())
                                               , Q_ARG(const Phonon::Path*,p->player->path())
                                               , Q_ARG(const QStringList*,p->playlist->list()) );
}

void MainWindow::addWidget( QWidget *widget , int default_height , SWidgetManager::ResizeMode mode )
{
    insertWidget( p->wmanager->count() , widget , default_height , mode );
}

void MainWindow::removeWidget( QWidget *widget )
{
    p->wmanager->remove( widget );
}

void MainWindow::playPause()
{
    p->player->playPause();
}

void MainWindow::previous()
{
    p->player->previous();
}

void MainWindow::stop()
{
    p->player->stop();
}

void MainWindow::next()
{
    p->playlist->next();
}

MainWindow::~MainWindow()
{
    delete p;
}
