#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <SPage>
#include <SApplication>
#include <SWidgetManager>

class MainWindowPrivate;
class MainWindow : public SPage
{
    Q_OBJECT
public:
    MainWindow( SApplication *parent );
    ~MainWindow();

    void addToList( const QStringList & files );
    void addToListAndPlay( const QStringList & files );

    void insertWidget( int index , QWidget *widget , int default_height = 1 , SWidgetManager::ResizeMode mode = SWidgetManager::PERCENT );
    void addWidget( QWidget *widget , int default_height = 1 , SWidgetManager::ResizeMode mode = SWidgetManager::PERCENT );
    void removeWidget( QWidget *widget );

signals:

public slots:
    void setSource( const QString & file );

    void playPause();
    void next();
    void previous();
    void stop();

private slots:
    void playing( const QString & file );

private:
    MainWindowPrivate *p;
};

#endif // MAINWINDOW_H
