#ifndef PLAYERCORE_H
#define PLAYERCORE_H

#include <QToolBar>

#include <phonon/mediaobject.h>
#include <phonon/audiooutput.h>

class SPage;
class PlayerCorePrivate;
class PlayerCore : public QToolBar
{
    Q_OBJECT
public:
    PlayerCore( SPage *page , QWidget *parent = 0 );
    ~PlayerCore();

    const Phonon::MediaObject *mediaObject() const;
    const Phonon::AudioOutput *audioOutput() const;
    const Phonon::Path *path() const;

public slots:
    void setSource( const QString & file );
    void play();
    void playPause();

    void next();
    void previous();
    void stop();

    void finish();

signals:
    void finished();
    void prev();

private slots:
    void finished_prev();

    void effect_triggered( QAction *act );
    void acceptEffect();
    void rejectEffect();

private:
    void setupActions();
    void settingUpEffects();

private:
    PlayerCorePrivate *p;
};

#endif // PLAYERCORE_H
