#ifndef PLAYLIST_H
#define PLAYLIST_H

#include <QFrame>

class PlayListPrivate;
class PlayList : public QFrame
{
    Q_OBJECT
public:
    PlayList(QWidget *parent = 0);
    ~PlayList();

    enum RepeatStatus{
        List,
        Track,
        Off
    };

    void addFolder( const QString & path );

    void addFiles( const QStringList & files );
    void addFile( const QString & file );

    void addFilesAndPlay( const QStringList & files );
    void addFileAndPlay( const QString & file );

    const QStringList *list() const;

public slots:
    void play( const QString & address );

    void next();
    void previous();
    void playCurrent();

    void clear();

signals:
    void playing( const QString & address );

private slots:
    void itemDoubleClicked( QWidget *widget );
    void itemClicked( QWidget *widget );

protected:
    void paintEvent( QPaintEvent *event );
    void dropEvent( QDropEvent *event );
    void dragEnterEvent( QDragEnterEvent *event );

private:
    PlayListPrivate *p;
};

#endif // PLAYLIST_H
