#define ICON_SIZE QSize(22,22)

#include "playlistitem.h"

#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QLabel>
#include <QPushButton>

#include <SMasterIcons>
#include <SPictureWidget>

class PlayListItemPrivate
{
public:
    SPictureWidget *picture;
    QLabel *name_label;
    QLabel *lenght_label;

    QHBoxLayout *layout;

    QString address;
};

PlayListItem::PlayListItem(QWidget *parent) :
    QWidget(parent)
{
    p = new PlayListItemPrivate;

    p->picture = new SPictureWidget();
        p->picture->setFixedSize( ICON_SIZE );
        p->picture->drawIcon( SMasterIcons::icon( QSize(48,48) , "audio-x-generic.png" ) , ICON_SIZE );

    p->name_label = new QLabel();
    p->lenght_label = new QLabel();

    p->layout = new QHBoxLayout( this );
        p->layout->addWidget( p->picture      );
        p->layout->addWidget( p->name_label   );
        p->layout->addWidget( p->lenght_label );
        p->layout->setContentsMargins( 4 , 4 , 4 , 4 );
}

void PlayListItem::set( const QString & address , const QString & name , const QString & lenght , PlayListItem::Status state )
{
    p->address = address;

    p->name_label->setText( name );
    p->lenght_label->setText( lenght );
    setState( state );
}

void PlayListItem::setState( Status state )
{
    switch( static_cast<int>(state) )
    {
    case Play :
        p->picture->drawIcon( SMasterIcons::icon( QSize(48,48) , "media-playback-start.png" ) , ICON_SIZE );
        break;

    case Paused :
        p->picture->drawIcon( SMasterIcons::icon( QSize(48,48) , "media-playback-start.png" ) , ICON_SIZE );
        break;

    case Stopped :
        p->picture->drawIcon( SMasterIcons::icon( QSize(48,48) , "audio-x-generic.png" ) , ICON_SIZE );
        break;
    }
}

const QString & PlayListItem::address() const
{
    return p->address;
}

PlayListItem::~PlayListItem()
{
    delete p;
}
